/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.textures;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureMap.class})
@ClientOnlyMixin
public abstract class MixinTextureMap {
    @Shadow
    @Final
    private Map<String, TextureAtlasSprite> field_110574_e;
    @Shadow
    @Final
    private String field_94254_c;
    @Shadow
    private int field_147636_j;
    private static final String TEXTURE_LOADER_CORE = "loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I";
    private static final String TEXTURE_LOADER_CORE_OF = "loadTextureAtlas(Lnet/minecraft/client/resources/IResourceManager;)V";
    private static final IResource EMPTY_META_RESOURCE = new IResource(){

        public ResourceLocation func_177241_a() {
            return new ResourceLocation("stub");
        }

        public InputStream func_110527_b() {
            return null;
        }

        public boolean func_110528_c() {
            return false;
        }

        @Nullable
        public <T extends IMetadataSection> T func_110526_a(String sectionName) {
            return null;
        }

        public String func_177240_d() {
            return null;
        }

        public void close() throws IOException {
        }
    };
    private static final AtomicInteger loadedCount = new AtomicInteger(0);
    private static final Set<Class<?>> SAFE_CLASSES;

    @Shadow
    protected abstract ResourceLocation func_184396_a(TextureAtlasSprite var1);

    @ModifyConstant(method={"loadTextureAtlas"}, constant={@Constant(stringValue="Texture stitching")}, require=0)
    private String correctMessage(String original) {
        return "Texture loading";
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I", "loadTextureAtlas(Lnet/minecraft/client/resources/IResourceManager;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/PngSizeInfo;makeFromResource(Lnet/minecraft/client/resources/IResource;)Lnet/minecraft/client/renderer/texture/PngSizeInfo;"))
    private PngSizeInfo skipPngLoad(IResource resource) {
        return null;
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I", "loadTextureAtlas(Lnet/minecraft/client/resources/IResourceManager;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResourceManager;getResource(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/IResource;"))
    private IResource skipResourceLoad(IResourceManager manager, ResourceLocation location) {
        return EMPTY_META_RESOURCE;
    }

    @Redirect(method={"generateMipmaps"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;error(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", ordinal=0))
    private void skipErrorForWrongDimension(Logger logger, String msg, Object o1, Object o2, IResourceManager resourceManager, TextureAtlasSprite texture) {
        ResourceLocation resourcelocation = this.func_184396_a(texture);
        FMLClientHandler.instance().trackBrokenTexture(resourcelocation, ((RuntimeException)o2).getMessage());
    }

    @Redirect(method={"generateMipmaps"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;error(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", ordinal=1))
    private void skipErrorForMissing(Logger logger, String msg, Object o1, Object o2, IResourceManager resourceManager, TextureAtlasSprite texture) {
        ResourceLocation resourcelocation = this.func_184396_a(texture);
        FMLClientHandler.instance().trackMissingTexture(resourcelocation);
    }

    @Inject(method={"loadTextureAtlas"}, at={@At(value="INVOKE", target="Ljava/util/List;clear()V", ordinal=0)})
    private void preloadTextures(IResourceManager resourceManager, CallbackInfo ci) {
        Stopwatch watch = Stopwatch.createStarted();
        loadedCount.set(0);
        int numSubmittedSprites = 0;
        Object2IntOpenHashMap invalidClasses = new Object2IntOpenHashMap();
        for (Map.Entry<String, TextureAtlasSprite> entry : this.field_110574_e.entrySet()) {
            TextureAtlasSprite sprite = entry.getValue();
            if (sprite == null) continue;
            if (!FMLClientHandler.instance().hasError() && SAFE_CLASSES.contains(sprite.getClass())) {
                VintageFix.WORKER_POOL.execute(() -> {
                    try {
                        sprite.func_188538_a(null, false);
                        ResourceLocation fileLocation = this.func_184396_a(sprite);
                        try (IResource resource = resourceManager.func_110536_a(fileLocation);){
                            sprite.func_188539_a(resource, this.field_147636_j + 1);
                        }
                        sprite.func_147963_d(this.field_147636_j);
                    }
                    catch (IOException | RuntimeException e) {
                        try {
                            sprite.func_188538_a(null, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    finally {
                        loadedCount.incrementAndGet();
                    }
                });
                ++numSubmittedSprites;
                continue;
            }
            invalidClasses.compute(sprite.getClass(), (k, v) -> v == null ? 1 : v + 1);
        }
        int totalRegisteredSprites = this.field_110574_e.size();
        invalidClasses.forEach((clz, i) -> VintageFix.LOGGER.warn("Can't preload sprite class {} (seen {}/{} times)", (Object)clz.getName(), i, (Object)totalRegisteredSprites));
        ProgressManager.ProgressBar bar = ProgressManager.push((String)("Preloading " + totalRegisteredSprites + " textures"), (int)1);
        long timeToBlock = TimeUnit.MILLISECONDS.toNanos(30L);
        while (loadedCount.get() < numSubmittedSprites) {
            LockSupport.parkNanos(timeToBlock);
        }
        watch.stop();
        VintageFix.LOGGER.info("Preloaded {} sprites in {}", (Object)numSubmittedSprites, (Object)watch);
        bar.step("done");
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Redirect(method={"loadTexture(Lnet/minecraft/client/renderer/texture/Stitcher;Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraftforge/fml/common/ProgressManager$ProgressBar;II)I", "loadTextureAtlas(Lnet/minecraft/client/resources/IResourceManager;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;loadSprite(Lnet/minecraft/client/renderer/texture/PngSizeInfo;Z)V"))
    private void skipResetSprite(TextureAtlasSprite sprite, PngSizeInfo info, boolean flag) throws IOException {
        if (sprite.getClass() != TextureAtlasSprite.class || sprite.func_110970_k() == 0) {
            sprite.func_188538_a(info, flag);
        }
    }

    @Inject(method={"generateMipmaps"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipPreloadedSprite(IResourceManager manager, TextureAtlasSprite sprite, CallbackInfoReturnable<Boolean> cir) {
        if (sprite.getClass() == TextureAtlasSprite.class && sprite.func_110970_k() > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"generateMipmaps"}, at={@At(value="RETURN")}, cancellable=true)
    private void skipStitchEmptySprite(IResourceManager manager, TextureAtlasSprite sprite, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValueZ()) {
            try {
                sprite.func_147965_a(0);
            }
            catch (RuntimeException e) {
                VintageFix.LOGGER.warn("Skipped stitching empty sprite {}", (Object)sprite.func_94215_i());
                cir.setReturnValue((Object)false);
            }
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String clzName : ImmutableList.of((Object)"net.minecraft.client.renderer.texture.TextureAtlasSprite")) {
            try {
                builder.add(Class.forName(clzName));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        SAFE_CLASSES = builder.build();
    }
}

