/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap.immutable;

import com.google.common.collect.FerriteCoreEntrySetAccess;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import org.embeddedt.vintagefix.ducks.FastMapStateHolder;
import org.embeddedt.vintagefix.fastmap.FastMap;
import org.embeddedt.vintagefix.fastmap.immutable.FastMapEntryIterator;

public class FastMapEntryEntrySet
extends FerriteCoreEntrySetAccess<IProperty<?>, Comparable<?>> {
    private final FastMapStateHolder<?> viewedState;

    public FastMapEntryEntrySet(FastMapStateHolder<?> viewedState) {
        this.viewedState = viewedState;
    }

    @Nonnull
    public UnmodifiableIterator<Map.Entry<IProperty<?>, Comparable<?>>> iterator() {
        return new FastMapEntryIterator<Map.Entry<IProperty<?>, Comparable<?>>>(this.viewedState){

            @Override
            protected Map.Entry<IProperty<?>, Comparable<?>> getEntry(int propertyIndex, FastMap<?> map, int stateIndex) {
                return map.getEntry(propertyIndex, stateIndex);
            }
        };
    }

    public int size() {
        return this.viewedState.getStateMap().numProperties();
    }

    public boolean contains(@Nullable Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Comparable<?> valueInMap = this.viewedState.getStateMap().getValue(this.viewedState.getStateIndex(), ((Map.Entry)object).getKey());
        return valueInMap != null && valueInMap.equals(((Map.Entry)object).getValue());
    }

    public boolean isPartialView() {
        return false;
    }
}

