/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.core;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.core.LateMixins;
import org.embeddedt.vintagefix.core.VintageFixCore;
import org.embeddedt.vintagefix.transformercache.TransformerCache;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"VintageFix Mixin Loader");
    private static final String PACKAGE_PREFIX = "org.embeddedt.vintagefix.";
    private static final ImmutableMap<String, Consumer<PotentialMixin>> MIXIN_PROCESSING_MAP = ImmutableMap.builder().put((Object)"Lorg/spongepowered/asm/mixin/Mixin;", p -> {
        p.valid = true;
    }).put((Object)"Lorg/embeddedt/vintagefix/annotation/ClientOnlyMixin;", p -> {
        p.isClientOnly = true;
    }).put((Object)"Lorg/embeddedt/vintagefix/annotation/LateMixin;", p -> {
        p.isLate = true;
    }).build();
    private static final List<PotentialMixin> allMixins = new ArrayList<PotentialMixin>();
    private static Properties config;
    private static final ImmutableMap<String, Boolean> extraBaseNames;

    private void considerClass(String pathString) throws IOException {
        try (InputStream stream = MixinConfigPlugin.class.getClassLoader().getResourceAsStream("org/embeddedt/vintagefix/mixin/" + pathString);){
            if (stream == null) {
                return;
            }
            ClassReader reader = new ClassReader(stream);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 7);
            if (node.invisibleAnnotations == null) {
                return;
            }
            PotentialMixin mixin = new PotentialMixin();
            mixin.className = node.name.replace('/', '.');
            for (AnnotationNode annotation : node.invisibleAnnotations) {
                Consumer consumer = (Consumer)MIXIN_PROCESSING_MAP.get((Object)annotation.desc);
                if (consumer == null) continue;
                consumer.accept(mixin);
            }
            if (mixin.valid) {
                allMixins.add(mixin);
            }
        }
    }

    private static String mixinClassNameToBaseName(String mixinClassName) {
        String noPrefix = mixinClassName.replace(PACKAGE_PREFIX, "");
        return noPrefix.substring(0, noPrefix.lastIndexOf(46));
    }

    private static void writeOrderedProperties(Properties props, OutputStream stream) throws IOException {
        try (PrintWriter writer = new PrintWriter(stream);){
            writer.println("# VintageFix config file");
            writer.println();
            ArrayList<Object> lst = new ArrayList<Object>(props.keySet());
            lst.sort(Comparator.naturalOrder());
            for (String string : lst) {
                writer.println(string + "=" + props.getProperty(string));
            }
        }
    }

    public void onLoad(String s) {
        if (allMixins.size() == 0) {
            Object list;
            try {
                FileSystem fs;
                URI uri = Objects.requireNonNull(MixinConfigPlugin.class.getResource("/mixins.vintagefix.json")).toURI();
                try {
                    fs = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException var11) {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                Path basePath = fs.getPath("org", "embeddedt", "vintagefix", "mixin").toAbsolutePath();
                try (Object stream = Files.walk(basePath, new FileVisitOption[0]);){
                    list = stream.collect(Collectors.toList());
                }
                stream = list.iterator();
                while (stream.hasNext()) {
                    String pathString;
                    Path p = (Path)stream.next();
                    if (p == null || !(pathString = (p = basePath.relativize(p.toAbsolutePath())).toString()).endsWith(".class")) continue;
                    this.considerClass(pathString);
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("Found {} mixins", (Object)allMixins.size());
            config = new Properties();
            File targetConfig = new File(Launch.minecraftHome, "config" + File.separator + "vintagefix.properties");
            try {
                Object stream2;
                if (targetConfig.exists()) {
                    try {
                        stream2 = Files.newInputStream(targetConfig.toPath(), new OpenOption[0]);
                        list = null;
                        try {
                            config.load((InputStream)stream2);
                        }
                        catch (Throwable basePath) {
                            list = basePath;
                            throw basePath;
                        }
                        finally {
                            if (stream2 != null) {
                                if (list != null) {
                                    try {
                                        ((InputStream)stream2).close();
                                    }
                                    catch (Throwable basePath) {
                                        ((Throwable)list).addSuppressed(basePath);
                                    }
                                } else {
                                    ((InputStream)stream2).close();
                                }
                            }
                        }
                    }
                    catch (IllegalArgumentException stream2) {
                        // empty catch block
                    }
                }
                for (PotentialMixin m : allMixins) {
                    String baseName = MixinConfigPlugin.mixinClassNameToBaseName(m.className);
                    if (config.containsKey(baseName)) continue;
                    String value = ((Boolean)extraBaseNames.getOrDefault((Object)baseName, (Object)true)).toString();
                    LOGGER.warn("Added missing entry '{}' to config file with default value '{}'", (Object)baseName, (Object)value);
                    config.put(baseName, value);
                }
                for (Map.Entry entry : extraBaseNames.entrySet()) {
                    if (config.containsKey(entry.getKey())) continue;
                    config.put(entry.getKey(), ((Boolean)entry.getValue()).toString());
                }
                stream2 = Files.newOutputStream(targetConfig.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    MixinConfigPlugin.writeOrderedProperties(config, (OutputStream)stream2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream2 != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)stream2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)stream2).close();
                        }
                    }
                }
                LOGGER.info("Successfully saved config file");
            }
            catch (IOException e) {
                LOGGER.error("Exception handling config", (Throwable)e);
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetName, String className) {
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public static boolean isMixinClassApplied(String name) {
        String baseName = MixinConfigPlugin.mixinClassNameToBaseName(name);
        if (baseName.startsWith("mixin.textures") && VintageFixCore.OPTIFINE) {
            return false;
        }
        boolean isEnabled = Boolean.parseBoolean(config.getProperty(baseName, ""));
        if (!isEnabled) {
            LOGGER.warn("Not applying mixin '{}' as '{}' is disabled in config", (Object)name, (Object)baseName);
        }
        return isEnabled;
    }

    public List<String> getMixins() {
        MixinEnvironment.Phase phase = MixinEnvironment.getCurrentEnvironment().getPhase();
        if (phase == MixinEnvironment.Phase.DEFAULT) {
            if (!LateMixins.atLateStage && Boolean.getBoolean("vintagefix.transformerCache")) {
                TransformerCache.instance.init();
            }
            MixinEnvironment.Side side = MixinEnvironment.getCurrentEnvironment().getSide();
            List<String> list = allMixins.stream().filter(p -> !p.isClientOnly || side == MixinEnvironment.Side.CLIENT).filter(p -> p.isLate == LateMixins.atLateStage).map(p -> p.className).filter(MixinConfigPlugin::isMixinClassApplied).map(clz -> clz.replace("org.embeddedt.vintagefix.mixin.", "")).collect(Collectors.toList());
            for (String mixin : list) {
                LOGGER.debug("loading {}", (Object)mixin);
            }
            return list;
        }
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    static {
        extraBaseNames = ImmutableMap.builder().put((Object)"mixin.dynamic_resources.background_item_bake", (Object)true).put((Object)"mixin.bugfix.extrautils", (Object)false).put((Object)"mixin.version_protest", (Object)false).put((Object)"mixin.dynamic_resources.hide_model_exceptions", (Object)false).build();
    }

    static class PotentialMixin {
        String className;
        boolean valid;
        boolean isClientOnly;
        boolean isLate;

        PotentialMixin() {
        }
    }
}

