/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.core.MixinConfigPlugin;
import org.embeddedt.vintagefix.core.VintageFixCore;
import org.embeddedt.vintagefix.dynamicresources.CTMHelper;
import org.embeddedt.vintagefix.dynamicresources.IWeakTextureMap;
import org.embeddedt.vintagefix.impl.Deduplicator;
import org.embeddedt.vintagefix.transformercache.TransformerCache;
import org.embeddedt.vintagefix.util.VersionProtester;

public class VintageFixClient {
    public static boolean modernityPresent = false;
    public static ForkJoinTask<Set<ResourceLocation>> discoveredTextures = null;
    float lastIntegratedTickTime;
    AllocationRateTracker tracker = new AllocationRateTracker();
    private static boolean protestVersion = MixinConfigPlugin.isMixinClassApplied("mixin.version_protest.F3Change");
    private static float gameStartTime = -1.0f;

    public VintageFixClient() {
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (Object)new byte[0], (String)"field_71444_a");
        if (Loader.isModLoaded((String)"ctm")) {
            MinecraftForge.EVENT_BUS.register(CTMHelper.class);
        }
        if (VintageFixCore.OPTIFINE) {
            VintageFix.LOGGER.fatal("OptiFine detected, there may be issues");
        }
    }

    @SubscribeEvent
    public void registerListener(ColorHandlerEvent.Block event) {
        Deduplicator.registerReloadListener();
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                List<IResourcePack> theList = VintageFixClient.getResourcePackList();
                modernityPresent = theList.stream().anyMatch(pack -> pack.func_130077_b().toLowerCase(Locale.ROOT).contains("modernity"));
            }
        });
    }

    private void registerSpriteSafe(TextureMap map, ResourceLocation location) {
        try {
            ((IWeakTextureMap)map).registerSpriteWeak(location);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void registerSpriteIfPresent(TextureMap map, ResourceLocation location) {
        boolean present = false;
        try (IResource ignored1 = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), "textures/" + location.func_110623_a() + ".png"));){
            present = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (present) {
            this.registerSpriteSafe(map, location);
        }
    }

    public static List<IResourcePack> getResourcePackList() {
        LinkedHashSet resourcePacks = new LinkedHashSet();
        SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        Map domainManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)manager, (String)"field_110548_a");
        for (FallbackResourceManager fallback : domainManagers.values()) {
            List fallbackPacks = (List)ObfuscationReflectionHelper.getPrivateValue(FallbackResourceManager.class, (Object)fallback, (String)"field_110540_a");
            resourcePacks.addAll(fallbackPacks);
        }
        return new ArrayList<IResourcePack>(resourcePacks);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void collectTextures(TextureStitchEvent.Pre event) {
        if (MixinConfigPlugin.isMixinClassApplied("mixin.dynamic_resources.TextureCollectionMixin")) {
            Objects.requireNonNull(discoveredTextures, "Future not found");
            Set<ResourceLocation> allTextures = discoveredTextures.join();
            TextureMap map = event.getMap();
            for (ResourceLocation tex : allTextures) {
                this.registerSpriteSafe(map, tex);
            }
            for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
                if (f.getStill() != null) {
                    this.registerSpriteIfPresent(map, f.getStill());
                }
                if (f.getFlowing() == null) continue;
                this.registerSpriteIfPresent(map, f.getFlowing());
            }
            discoveredTextures = null;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.side.isServer() && event.phase == TickEvent.Phase.END) {
            IntegratedServer srv = Minecraft.func_71410_x().func_71401_C();
            if (srv != null) {
                long currentTickTime = srv.field_71311_j[srv.func_71259_af() % 100];
                this.lastIntegratedTickTime = this.lastIntegratedTickTime * 0.8f + (float)currentTickTime / 1000000.0f * 0.2f;
            } else {
                this.lastIntegratedTickTime = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !VintageFixCore.OPTIFINE) {
            this.tracker.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderF3(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.field_71474_y.field_74330_P) {
            return;
        }
        IntegratedServer srv = minecraft.func_71401_C();
        if (srv != null) {
            event.getLeft().add(2, String.format("Integrated server @ %.0f ms ticks", Float.valueOf(this.lastIntegratedTickTime)));
        }
        if (!VintageFixCore.OPTIFINE) {
            event.getRight().add(2, String.format("Allocation rate: %03dMB /s", this.tracker.getAllocationRate()));
        }
        if (protestVersion) {
            event.getLeft().set(0, VersionProtester.protest((String)event.getLeft().get(0)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!event.isCanceled() && event.getGui() instanceof GuiMainMenu && gameStartTime == -1.0f) {
            gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            VintageFix.LOGGER.info("Game launch took " + gameStartTime + " seconds");
            TransformerCache.instance.printStats();
        }
    }

    private static class AllocationRateTracker {
        private static final List<GarbageCollectorMXBean> COLLECTORS = ManagementFactory.getGarbageCollectorMXBeans();
        private static final long MINIMUM_TIME_AFTER_GC = 200L;
        long prevFreeMem = Runtime.getRuntime().freeMemory();
        long timeBase = 0L;
        long lastGcCount = -1L;
        long allocationRate = 0L;

        private AllocationRateTracker() {
        }

        void tick() {
            long freeMem = Runtime.getRuntime().freeMemory();
            if (this.gcCountChanged() || freeMem > this.prevFreeMem) {
                this.prevFreeMem = freeMem;
                this.timeBase = System.nanoTime();
                return;
            }
            long milliDelta = (System.nanoTime() - this.timeBase) / 1000000L;
            if (milliDelta <= 200L) {
                return;
            }
            long byteChange = this.prevFreeMem - freeMem;
            long allocationRateBytePerMilli = byteChange / milliDelta;
            this.allocationRate = allocationRateBytePerMilli * 1000L / 1000000L;
        }

        boolean gcCountChanged() {
            long c = 0L;
            for (GarbageCollectorMXBean collector : COLLECTORS) {
                c += collector.getCollectionCount();
            }
            boolean isSame = this.lastGcCount == c;
            this.lastGcCount = c;
            return !isSame;
        }

        long getAllocationRate() {
            return this.allocationRate;
        }
    }
}

