/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.IItemHandler;
import openblocks.OpenBlocks;
import openblocks.OpenBlocksGuiHandler;
import openblocks.common.entity.ai.EntityAICollectItem;
import openmods.api.VisibleForDocumentation;
import openmods.inventory.GenericInventory;
import openmods.utils.InventoryUtils;

@VisibleForDocumentation
public class EntityLuggage
extends EntityTameable
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> PROPERTY_INV_SIZE = EntityDataManager.func_187226_a(EntityLuggage.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int SIZE_SPECIAL = 54;
    public static final int SIZE_NORMAL = 27;
    private static final String TAG_ITEM_TAG = "ItemTag";
    private static final String TAG_SHINY = "shiny";
    protected GenericInventory inventory = this.createInventory(27);
    public boolean special;
    public int lastSound = 0;
    private NBTTagCompound itemTag;

    public static void registerFixes(DataFixer fixer) {
        EntityLuggage.func_189752_a((DataFixer)fixer, EntityLuggage.class);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(EntityLuggage.class, new String[]{"Items"}));
    }

    private GenericInventory createInventory(int size) {
        return new GenericInventory("luggage", false, size){

            public boolean func_70300_a(EntityPlayer player) {
                return !EntityLuggage.this.field_70128_L && player.func_70068_e((Entity)EntityLuggage.this) < 64.0;
            }
        };
    }

    public EntityLuggage(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70659_e(0.7f);
        this.func_191989_p(0.0f);
        this.func_70903_f(true);
        this.func_110163_bv();
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, (double)this.func_70689_ay(), 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICollectItem(this));
        this.func_184212_Q().func_187214_a(PROPERTY_INV_SIZE, (Object)this.inventory.func_70302_i_());
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateGround navigator = new PathNavigateGround((EntityLiving)this, worldIn);
        navigator.func_179693_d(true);
        return navigator;
    }

    public void setSpecial() {
        if (this.special) {
            return;
        }
        this.special = true;
        GenericInventory inventory = this.createInventory(54);
        inventory.copyFrom((IInventory)this.inventory);
        this.func_184212_Q().func_187227_b(PROPERTY_INV_SIZE, (Object)inventory.func_70302_i_());
        this.inventory = inventory;
    }

    public boolean isSpecial() {
        if (this.field_70170_p.field_72995_K) {
            return this.inventory.func_70302_i_() > 27;
        }
        return this.special;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int inventorySize = (Integer)this.func_184212_Q().func_187225_a(PROPERTY_INV_SIZE);
            if (this.inventory.func_70302_i_() != inventorySize) {
                this.inventory = this.createInventory(inventorySize);
            }
        }
        ++this.lastSound;
    }

    public GenericInventory getChestInventory() {
        return this.inventory;
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.convertToItem();
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return true;
        }
        if (!this.field_70128_L) {
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_77973_b() instanceof ItemNameTag) {
                return false;
            }
            if (this.field_70170_p.field_72995_K) {
                if (player.func_70093_af()) {
                    this.spawnPickupParticles();
                }
            } else if (player.func_70093_af()) {
                ItemStack luggageItem = this.convertToItem();
                if (player.field_71071_by.func_70441_a(luggageItem)) {
                    this.func_70106_y();
                    this.func_184185_a(SoundEvents.field_187638_cR, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            } else {
                this.func_184185_a(SoundEvents.field_187657_V, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                player.openGui((Object)OpenBlocks.instance, OpenBlocksGuiHandler.GuiId.luggage.ordinal(), player.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
        return true;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected void spawnPickupParticles() {
        double py = this.field_70163_u + (double)this.field_70131_O;
        for (int i = 0; i < 50; ++i) {
            double vx = this.field_70146_Z.nextGaussian() * 0.02;
            double vz = this.field_70146_Z.nextGaussian() * 0.02;
            double px = this.field_70165_t + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            double pz = this.field_70161_v + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, px, py, pz, vx, -1.0, vz, new int[0]);
        }
    }

    @Nonnull
    protected ItemStack convertToItem() {
        if (OpenBlocks.Items.luggage == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack luggageItem = new ItemStack(OpenBlocks.Items.luggage);
        NBTTagCompound tag = this.itemTag != null ? this.itemTag.func_74737_b() : new NBTTagCompound();
        this.inventory.writeToNBT(tag);
        luggageItem.func_77982_d(tag);
        String nameTag = this.func_95999_t();
        if (!Strings.isNullOrEmpty((String)nameTag)) {
            luggageItem.func_151001_c(nameTag);
        }
        return luggageItem;
    }

    public void restoreFromStack(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            this.inventory.readFromNBT(tag);
            if (this.inventory.func_70302_i_() > 27) {
                this.setSpecial();
            }
            NBTTagCompound tagCopy = tag.func_74737_b();
            tagCopy.func_82580_o("size");
            tagCopy.func_82580_o("Items");
            NBTTagCompound nBTTagCompound = this.itemTag = tagCopy.func_82582_d() ? null : tagCopy;
        }
        if (stack.func_82837_s()) {
            this.func_96094_a(stack.func_82833_r());
        }
    }

    public boolean canConsumeStackPartially(@Nonnull ItemStack stack) {
        return InventoryUtils.canInsertStack((IItemHandler)this.inventory.getHandler(), (ItemStack)stack);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(OpenBlocks.Sounds.ENTITY_LUGGAGE_WALK, 0.3f, 0.7f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
    }

    public void storeItemTag(NBTTagCompound itemTag) {
        this.itemTag = itemTag;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a(TAG_SHINY, this.special);
        this.inventory.writeToNBT(tag);
        if (this.itemTag != null) {
            tag.func_74782_a(TAG_ITEM_TAG, (NBTBase)this.itemTag);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n(TAG_SHINY)) {
            this.setSpecial();
        }
        this.inventory.readFromNBT(tag);
        this.itemTag = tag.func_150297_b(TAG_ITEM_TAG, 10) ? tag.func_74775_l(TAG_ITEM_TAG) : null;
    }

    public void func_70077_a(EntityLightningBolt lightning) {
        this.setSpecial();
    }

    public boolean func_180431_b(DamageSource dmg) {
        return true;
    }

    public void func_70606_j(float health) {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.inventory.func_70302_i_());
    }

    public void readSpawnData(ByteBuf data) {
        this.inventory = this.createInventory(data.readInt());
    }

    public double func_70042_X() {
        return 0.825;
    }
}

