/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class WorldFileData {
    private static final FileFilter MCA_FILTER = new ExtFileFilter(".MCA");
    private Map<CoordXZ, List<Boolean>> regionChunkExistence = new HashMap<CoordXZ, List<Boolean>>();
    private File[] regionFiles = null;
    private ICommandSender requester = null;

    public WorldFileData(World world, ICommandSender requester) {
        this.requester = requester;
        File rootDir = world.field_73011_w.getDimension() == 0 ? DimensionManager.getCurrentSaveRootDirectory() : new File(DimensionManager.getCurrentSaveRootDirectory(), world.field_73011_w.getSaveFolder());
        File regionFolder = new File(rootDir, "region");
        if (!regionFolder.exists() || !regionFolder.isDirectory()) {
            throw new RuntimeException("Could not validate folder for world's region files. Tried to use " + regionFolder.getPath() + " as valid region folder.");
        }
        this.regionFiles = regionFolder.listFiles(MCA_FILTER);
        if (this.regionFiles == null || this.regionFiles.length == 0) {
            throw new RuntimeException("Could not find any region files. Looked in: " + regionFolder.getPath());
        }
        Log.debug("Using path '%s' for world '%s'", regionFolder.getAbsolutePath(), Worlds.getWorldName(world));
    }

    public int regionFileCount() {
        return this.regionFiles.length;
    }

    public File regionFile(int index) {
        if (this.regionFiles.length < index) {
            return null;
        }
        return this.regionFiles[index];
    }

    public CoordXZ regionFileCoordinates(int index) {
        File regionFile = this.regionFile(index);
        String[] coords = regionFile.getName().split("\\.");
        try {
            int x = Integer.parseInt(coords[1]);
            int z = Integer.parseInt(coords[2]);
            return new CoordXZ(x, z);
        }
        catch (Exception ex) {
            this.sendMessage("Error! Region file found with abnormal name: " + regionFile.getName());
            return null;
        }
    }

    public boolean doesChunkExist(int x, int z) {
        CoordXZ region = new CoordXZ(CoordXZ.chunkToRegion(x), CoordXZ.chunkToRegion(z));
        return this.getRegionData(region).get(this.coordToRegionOffset(x, z));
    }

    public boolean isChunkFullyGenerated(int x, int z) {
        return this.doesChunkExist(x, z) && this.doesChunkExist(x + 1, z) && this.doesChunkExist(x - 1, z) && this.doesChunkExist(x, z + 1) && this.doesChunkExist(x, z - 1);
    }

    public void chunkExistsNow(int x, int z) {
        CoordXZ region = new CoordXZ(CoordXZ.chunkToRegion(x), CoordXZ.chunkToRegion(z));
        this.getRegionData(region).set(this.coordToRegionOffset(x, z), true);
    }

    private int coordToRegionOffset(int x, int z) {
        z %= 32;
        if ((x %= 32) < 0) {
            x += 32;
        }
        if (z < 0) {
            z += 32;
        }
        return x + z * 32;
    }

    private List<Boolean> getRegionData(CoordXZ region) {
        int i;
        List<Boolean> data = this.regionChunkExistence.get(region);
        if (data != null) {
            return data;
        }
        data = new ArrayList<Boolean>(1024);
        for (i = 0; i < 1024; ++i) {
            data.add(Boolean.FALSE);
        }
        for (i = 0; i < this.regionFiles.length; ++i) {
            CoordXZ coord = this.regionFileCoordinates(i);
            if (!coord.equals(region)) continue;
            try (RandomAccessFile regionData = new RandomAccessFile(this.regionFile(i), "r");){
                Log.trace("Trying to read region file '%s'", this.regionFile(i));
                for (int j = 0; j < 1024; ++j) {
                    if (regionData.readInt() == 0) continue;
                    data.set(j, true);
                }
                continue;
            }
            catch (FileNotFoundException ex) {
                this.sendMessage("Error! Could not open region file to find generated chunks: " + this.regionFile(i).getName());
                continue;
            }
            catch (IOException ex) {
                this.sendMessage("Error! Could not read region file to find generated chunks: " + this.regionFile(i).getName());
            }
        }
        this.regionChunkExistence.put(region, data);
        return data;
    }

    private void sendMessage(String text) {
        Log.info("[WorldData] " + text, new Object[0]);
        if (this.requester != null) {
            Util.chat(this.requester, "[WorldData] " + text, new Object[0]);
        }
    }

    private static class ExtFileFilter
    implements FileFilter {
        String ext;

        public ExtFileFilter(String extension) {
            this.ext = extension.toLowerCase();
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isFile() && file.getName().toLowerCase().endsWith(this.ext);
        }
    }
}

