/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileMod;

public class TileRFGenerator
extends TileMod
implements IManaReceiver,
ITickable {
    private static final int MANA_TO_FE = 10;
    private static final int MAX_ENERGY = 12800;
    private static final String TAG_MANA = "mana";
    int energy = 0;
    private final IEnergyStorage energyHandler = new IEnergyStorage(){

        public int getEnergyStored() {
            return TileRFGenerator.this.energy;
        }

        public int getMaxEnergyStored() {
            return 12800;
        }

        public boolean canExtract() {
            return false;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public boolean canReceive() {
            return false;
        }
    };

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nullable EnumFacing side) {
        return cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyHandler);
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int transfer = Math.min(this.energy, 1600);
            this.energy -= transfer;
            this.energy += this.transmitEnergy(transfer);
        }
    }

    private int transmitEnergy(int energy) {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te;
            BlockPos neighbor = this.func_174877_v().func_177972_a(e);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IEnergyStorage storage = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, e.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, e.func_176734_d());
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (storage == null || (energy -= storage.receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    @Override
    public int getCurrentMana() {
        return this.energy / 10;
    }

    @Override
    public boolean isFull() {
        return this.energy >= 12800;
    }

    @Override
    public void recieveMana(int mana) {
        this.energy = Math.min(12800, this.energy + mana * 10);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.energy);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.energy = cmp.func_74762_e(TAG_MANA);
    }
}

