/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.capabilities.energy.adapter;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.machinemuse.numina.common.capabilities.energy.ElectricConversions;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux", striprefs=true), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2", striprefs=true), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="ic2", striprefs=true)})
public interface IMuseElectricItem
extends IEnergyContainerItem,
ISpecialElectricItem,
IElectricItemManager {
    default public IElectricItemManager getManager(ItemStack stack) {
        return this;
    }

    default public double getTransferLimit(ItemStack itemStack) {
        if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IMuseElectricItem)) {
            return 0.0;
        }
        IMuseElectricItem iMuseElectricItem = (IMuseElectricItem)itemStack.func_77973_b();
        return ElectricConversions.museEnergyToEU((double)iMuseElectricItem.getMaxEnergyStored(itemStack) * 0.75);
    }

    @Override
    default public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (amount == Double.POSITIVE_INFINITY || amount == Double.NEGATIVE_INFINITY) {
            amount = 5.3687091175E8;
        }
        int transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : ElectricConversions.museEnergyFromEU(this.getTransferLimit(itemStack));
        transfer = Math.abs(transfer);
        return ElectricConversions.museEnergyToEU(this.receiveEnergy(itemStack, transfer, simulate));
    }

    @Override
    default public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (amount == Double.POSITIVE_INFINITY || amount == Double.NEGATIVE_INFINITY) {
            amount = 5.3687091175E8;
        }
        int transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : ElectricConversions.museEnergyFromEU(this.getTransferLimit(itemStack));
        transfer = Math.abs(transfer);
        return ElectricConversions.museEnergyToEU(this.extractEnergy(itemStack, transfer, simulate));
    }

    @Override
    default public double getMaxCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getMaxEnergyStored(itemStack));
    }

    @Override
    default public double getCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getEnergyStored(itemStack));
    }

    @Override
    default public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricConversions.museEnergyFromEU(amount) < this.getEnergyStored(itemStack);
    }

    @Override
    default public boolean use(ItemStack itemStack, double amount, EntityLivingBase entityLivingBase) {
        return ElectricItem.rawManager.use(itemStack, ElectricConversions.museEnergyToEU(amount), entityLivingBase);
    }

    @Override
    default public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        ElectricItem.rawManager.chargeFromArmor(itemStack, entityLivingBase);
    }

    @Override
    default public String getToolTip(ItemStack itemStack) {
        return null;
    }

    @Override
    default public int getTier(ItemStack itemStack) {
        return ElectricConversions.getTier(itemStack);
    }

    default public int receiveEnergy(ItemStack container, int maxExtract, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null);
        return energyStorage != null ? energyStorage.receiveEnergy(maxExtract, simulate) : 0;
    }

    default public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null);
        return energyStorage != null ? energyStorage.extractEnergy(maxExtract, simulate) : 0;
    }

    default public int getEnergyStored(ItemStack container) {
        IEnergyStorage energyStorage = (IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null);
        return energyStorage != null ? energyStorage.getEnergyStored() : 0;
    }

    default public int getMaxEnergyStored(ItemStack container) {
        IEnergyStorage energyStorage = (IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, null);
        return energyStorage != null ? energyStorage.getMaxEnergyStored() : 0;
    }
}

