/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import extracells.api.ECApi;
import extracells.api.IWirelessFluidTermHandler;
import extracells.api.IWirelessGasFluidTermHandler;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.misc.ModCompatibility;
import net.machinemuse.powersuits.common.base.MPSItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="extracells.api.IWirelessFluidTermHandler", modid="extracells", striprefs=true), @Optional.Interface(iface="appeng.api.features.IWirelessTermHandler", modid="appliedenergistics2", striprefs=true)})
public class TerminalHandler
implements IWirelessTermHandler,
IWirelessFluidTermHandler {
    public static void registerHandler() {
        if (ModCompatibility.isAppengLoaded()) {
            TerminalHandler handler = new TerminalHandler();
            TerminalHandler.registerAEHandler(handler);
            if (ModCompatibility.isExtraCellsLoaded()) {
                TerminalHandler.registerECHandler(handler);
            }
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAEHandler(TerminalHandler handler) {
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)handler);
    }

    @Optional.Method(modid="extracells")
    private static void registerECHandler(TerminalHandler handler) {
        ECApi.instance().registerWirelessTermHandler((IWirelessGasFluidTermHandler)handler);
    }

    public static NBTTagCompound openNbtData(@Nonnull ItemStack item) {
        NBTTagCompound compound = item.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            item.func_77982_d(compound);
        }
        return compound;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean canHandle(@Nonnull ItemStack is) {
        if (is.func_190926_b() || is.func_77977_a() == null) {
            return false;
        }
        return is.func_77977_a().equals(MPSItems.powerFist.func_77658_a());
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean usePower(EntityPlayer entityPlayer, double v, @Nonnull ItemStack itemStack) {
        if (v * NuminaConfig.INSTANCE.getAE2Ratio() < (double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)entityPlayer) * NuminaConfig.INSTANCE.getAE2Ratio()) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityPlayer, (int)((int)(v * NuminaConfig.INSTANCE.getAE2Ratio())));
            return true;
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean hasPower(EntityPlayer entityPlayer, double v, @Nonnull ItemStack itemStack) {
        return v * NuminaConfig.INSTANCE.getAE2Ratio() < (double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)entityPlayer) * NuminaConfig.INSTANCE.getAE2Ratio();
    }

    @Optional.Method(modid="extracells")
    public boolean isItemNormalWirelessTermToo(@Nonnull ItemStack is) {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IConfigManager getConfigManager(@Nonnull ItemStack itemStack) {
        WirelessConfig config = new WirelessConfig(itemStack);
        config.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        config.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        config.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        config.readFromNBT(itemStack.func_77978_p());
        return config;
    }

    @Optional.Method(modid="appliedenergistics2")
    public String getEncryptionKey(@Nonnull ItemStack item) {
        NBTTagCompound tag;
        if (!item.func_190926_b() && (tag = TerminalHandler.openNbtData(item)) != null) {
            return tag.func_74779_i("encKey");
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void setEncryptionKey(@Nonnull ItemStack item, String encKey, String name) {
        NBTTagCompound tag;
        if (!item.func_190926_b() && (tag = TerminalHandler.openNbtData(item)) != null) {
            tag.func_74778_a("encKey", encKey);
        }
    }

    @Optional.Interface(iface="appeng.api.util.IConfigManager", modid="appliedenergistics2", striprefs=true)
    class WirelessConfig
    implements IConfigManager {
        final ItemStack stack;
        private final Map<Settings, Enum<?>> enums = new EnumMap(Settings.class);

        public WirelessConfig(ItemStack itemStack) {
            this.stack = itemStack;
        }

        @Optional.Method(modid="appliedenergistics2")
        public Set<Settings> getSettings() {
            return this.enums.keySet();
        }

        @Optional.Method(modid="appliedenergistics2")
        public void registerSetting(Settings settings, Enum<?> anEnum) {
            if (!this.enums.containsKey(settings)) {
                this.putSetting(settings, anEnum);
            }
        }

        @Optional.Method(modid="appliedenergistics2")
        public Enum<?> getSetting(Settings settings) {
            if (this.enums.containsKey(settings)) {
                return this.enums.get(settings);
            }
            return null;
        }

        @Optional.Method(modid="appliedenergistics2")
        public Enum<?> putSetting(Settings settings, Enum<?> anEnum) {
            this.enums.put(settings, anEnum);
            this.writeToNBT(this.stack.func_77978_p());
            return anEnum;
        }

        @Optional.Method(modid="appliedenergistics2")
        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagCompound tag = new NBTTagCompound();
            if (tagCompound.func_74764_b("configWirelessTerminal")) {
                tag = tagCompound.func_74775_l("configWirelessTerminal");
            }
            for (Enum enum_ : this.enums.keySet()) {
                tag.func_74778_a(enum_.name(), this.enums.get(enum_).toString());
            }
            tagCompound.func_74782_a("configWirelessTerminal", (NBTBase)tag);
        }

        @Optional.Method(modid="appliedenergistics2")
        public void readFromNBT(NBTTagCompound tagCompound) {
            if (tagCompound.func_74764_b("configWirelessTerminal")) {
                NBTTagCompound tag = tagCompound.func_74775_l("configWirelessTerminal");
                for (Settings key : this.enums.keySet()) {
                    try {
                        if (!tag.func_74764_b(key.name())) continue;
                        String value = tag.func_74779_i(key.name());
                        Enum<?> oldValue = this.enums.get(key);
                        Object newValue = Enum.valueOf(oldValue.getClass(), value);
                        this.putSetting(key, (Enum<?>)newValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
    }
}

