/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.misc.ModCompatibility;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.common.utils.modulehelpers.OmniProbeHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OmniProbeModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    private ItemStack rcMeter = ItemStack.field_190927_a;
    private ItemStack conduitProbe = ItemStack.field_190927_a;
    private ItemStack teMultimeter = ItemStack.field_190927_a;

    public OmniProbeModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)4));
        ItemStack tHighest = new ItemStack(Items.field_151132_bS);
        if (ModCompatibility.isRailcraftLoaded()) {
            tHighest = this.rcMeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("railcraft", "tool_charge_meter")), 1);
        }
        if (ModCompatibility.isThermalExpansionLoaded()) {
            tHighest = this.teMultimeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thermalexpansion", "multimeter")), 1);
        }
        if (ModCompatibility.isEnderIOLoaded()) {
            tHighest = this.conduitProbe = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("enderio", "item_conduit_probe")), 1);
        }
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), tHighest);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "omniProbe";
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null || block.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            return EnumActionResult.PASS;
        }
        try {
            if (ModCompatibility.isEnderIOLoaded() && this.conduitProbe.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
            if (ModCompatibility.isRailcraftLoaded() && this.rcMeter.func_77973_b().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
            if (ModCompatibility.isThermalExpansionLoaded() && this.teMultimeter.func_77973_b().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EnumActionResult.PASS;
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!OmniProbeHelper.getEIOFacadeTransparency(item)) {
            OmniProbeHelper.setEIONoCompete(item, "omniProbe");
            OmniProbeHelper.setEIOFacadeTransparency(item, true);
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (!OmniProbeHelper.getEIONoCompete(item).isEmpty() && !OmniProbeHelper.getEIONoCompete(item).isEmpty()) {
            if (OmniProbeHelper.getEIONoCompete(item).equals("omniProbe")) {
                OmniProbeHelper.setEIONoCompete(item, "");
                if (OmniProbeHelper.getEIOFacadeTransparency(item)) {
                    OmniProbeHelper.setEIOFacadeTransparency(item, false);
                }
            }
        } else if (OmniProbeHelper.getEIOFacadeTransparency(item)) {
            OmniProbeHelper.setEIOFacadeTransparency(item, false);
        }
    }

    public float minF(float a, float b) {
        return a < b ? a : b;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return 0;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.omniProbe;
    }
}

