/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.movement;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.client.control.PlayerMovementInputWrapper;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.event.MovementManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class JetBootsModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public JetBootsModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.ionThruster, (int)2));
        this.addBasePropertyDouble("jetBootsEnergyCon", 0.0);
        this.addBasePropertyDouble("jetbootsThrust", 0.0);
        this.addTradeoffPropertyDouble("thrust", "jetBootsEnergyCon", 750.0, "RF");
        this.addTradeoffPropertyDouble("thrust", "jetbootsThrust", 0.08);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    public String getDataName() {
        return "jetBoots";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H()) {
            return;
        }
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        boolean hasFlightControl = ModuleManager.INSTANCE.itemHasActiveModule(helmet, "flightControl");
        double jetEnergy = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetBootsEnergyCon");
        double thrust = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetbootsThrust");
        PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get(player);
        if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)player)) {
            if (hasFlightControl && thrust > 0.0) {
                thrust = MovementManager.thrust(player, thrust, true);
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)(thrust * jetEnergy)));
            } else if (playerInput.jumpKey && player.field_70181_x < 0.5) {
                thrust = MovementManager.thrust(player, thrust, false);
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)(thrust * jetEnergy)));
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS);
            }
        } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS);
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.jetBoots;
    }
}

