/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.mining_enhancement;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IBlockBreakingModule;
import net.machinemuse.numina.common.module.IMiningEnhancementModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AquaAffinityModule
extends PowerModuleBase
implements IMiningEnhancementModule,
IBlockBreakingModule {
    public AquaAffinityModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)1));
        this.addBasePropertyDouble("underWaterEnergyCon", 0.0, "RF");
        this.addBasePropertyDouble("underWaterHarvSpeed", 0.2, "%");
        this.addTradeoffPropertyDouble("power", "underWaterEnergyCon", 1000.0);
        this.addTradeoffPropertyDouble("power", "underWaterHarvSpeed", 0.8);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MINING_ENHANCEMENT;
    }

    public String getDataName() {
        return "aquaAffinity";
    }

    public boolean canHarvestBlock(@Nonnull ItemStack stack, IBlockState state, EntityPlayer player, BlockPos pos, int playerEnergy) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving, int playerEnergy) {
        if (this.canHarvestBlock(itemStack, state, (EntityPlayer)entityLiving, pos, playerEnergy)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)((EntityPlayer)entityLiving), (int)this.getEnergyUsage(itemStack));
            return true;
        }
        return false;
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "underWaterEnergyCon");
    }

    @Nonnull
    public ItemStack getEmulatedTool() {
        return ItemStack.field_190927_a;
    }

    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (event.getNewSpeed() > 1.0f && (player.func_70055_a(Material.field_151586_h) || !player.field_70122_E) && ElectricItemUtils.getPlayerEnergy((EntityPlayer)player) > this.getEnergyUsage(stack)) {
            event.setNewSpeed((float)((double)(event.getNewSpeed() * 5.0f) * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "underWaterHarvSpeed")));
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.aquaAffinity;
    }
}

