/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.keybinds;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.gui.clickable.CheckBox;
import net.machinemuse.numina.client.gui.clickable.ClickableButton2;
import net.machinemuse.numina.client.gui.frame.IGuiFrame;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.client.control.KeybindManager;
import net.machinemuse.powersuits.client.control.MPSKeyBinding;
import net.machinemuse.powersuits.client.event.RenderEventHandler;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.settings.KeyModifier;

public class KeybindingFrame
extends ScrollableFrame {
    @Nullable
    MPSKeyBinding keybindingToRemap = null;
    NonNullList<IPowerModule> iPowerModules = NonNullList.func_191196_a();
    boolean selecting;
    List<KeyBindSubFrame> keyBindSubFrames;

    public KeybindingFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        super((IRect)new DrawableMuseRect(topleft, bottomright, borderColour, insideColour));
        this.iPowerModules.addAll((Collection)ModuleManager.INSTANCE.getModuleMap().values().stream().filter(IToggleableModule.class::isInstance).collect(Collectors.toList()));
        this.selecting = false;
        this.loadConditions();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            for (KeyBindSubFrame subframe : this.keyBindSubFrames) {
                if (!subframe.mouseClicked(mouseX, mouseY + this.getCurrentScrollPixels(), button)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        return super.mouseScrolled(mouseX, mouseY, dWheel);
    }

    public void loadConditions() {
        this.keyBindSubFrames = new ArrayList<KeyBindSubFrame>();
        KeybindManager.INSTANCE.getMPSKeybinds().forEach(keyBinding -> {
            KeyBindSubFrame prev = this.keyBindSubFrames.size() > 0 ? this.keyBindSubFrames.get(this.keyBindSubFrames.size() - 1) : null;
            KeyBindSubFrame subFrame = new KeyBindSubFrame(this.left(), this.top(), this.width() - 8.0, (MPSKeyBinding)((Object)keyBinding), prev);
            this.keyBindSubFrames.add(subFrame);
            this.totalSize = (int)((double)this.totalSize + subFrame.height());
        });
    }

    public void keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.keybindingToRemap != null) {
            if (keyCode == 1) {
                this.keybindingToRemap.setKeyModifierAndCode(KeyModifier.NONE, 0);
                Minecraft.func_71410_x().field_71474_y.func_151440_a((KeyBinding)this.keybindingToRemap, 0);
            } else if (keyCode != 0) {
                this.keybindingToRemap.setKeyModifierAndCode(KeyModifier.getActiveModifier(), keyCode);
                Minecraft.func_71410_x().field_71474_y.func_151440_a((KeyBinding)this.keybindingToRemap, keyCode);
            } else if (typedChar > '\u0000') {
                this.keybindingToRemap.setKeyModifierAndCode(KeyModifier.getActiveModifier(), typedChar + 256);
                Minecraft.func_71410_x().field_71474_y.func_151440_a((KeyBinding)this.keybindingToRemap, typedChar + 256);
            }
            if (!KeyModifier.isKeyCodeModifier((int)keyCode)) {
                this.keybindingToRemap = null;
            }
            KeyBinding.func_74508_b();
        } else {
            super.keyTyped(typedChar, keyCode);
        }
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        super.preRender(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(-this.currentScrollPixels), (double)0.0);
        this.keyBindSubFrames.forEach(subframe -> subframe.render(mouseX, mouseY, partialTicks));
        GlStateManager.func_179121_F();
        super.postRender(mouseX, mouseY, partialTicks);
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        if (this.isEnabled() && this.isVisible()) {
            return this.keyBindSubFrames.stream().filter(subframe -> subframe.getToolTip(mouseX, (int)(mouseY + this.getCurrentScrollPixels())) != null).map(subframe -> subframe.getToolTip(mouseX, (int)(mouseY + this.getCurrentScrollPixels()))).findFirst().orElse(null);
        }
        return super.getToolTip(mouseX, mouseY);
    }

    public class KeyBindSubFrame<T extends IRect>
    implements IGuiFrame {
        IPowerModule module;
        public CheckBox checkbox;
        public ClickableButton2 button;
        public MPSKeyBinding kb;
        T border;

        public KeyBindSubFrame(double left, double top, double width, MPSKeyBinding kb, KeyBindSubFrame aboveThis) {
            this.setRect((IRect)new MuseRect(left, top, left + width, top + 22.0, false));
            this.setBelow((IRect)aboveThis);
            this.kb = kb;
            this.module = ModuleManager.INSTANCE.getModule(kb.dataName);
            this.checkbox = new CheckBox(-1, new MusePoint2D(this.left() + 28.0, this.top() + 4.0), I18n.func_74838_a((String)(this.module.getUnlocalizedName() + ".name")), kb.showOnHud);
            this.checkbox.setOnPressed(pressed -> {
                kb.showOnHud = this.checkbox.isChecked();
                KeybindManager.INSTANCE.writeOutKeybinds();
                RenderEventHandler.makeKBDisplayList();
            });
            this.button = new ClickableButton2(this.right() - 97.0, this.top() + 1.0, 95.0, true);
            this.button.setOnPressed(onPressed -> {
                KeybindingFrame.this.keybindingToRemap = kb;
            });
        }

        public IRect getRect() {
            return this.border;
        }

        public void setRect(IRect rect) {
            this.border = rect;
        }

        public void render(double mouseX, double mouseY, float partialTicks) {
            MuseTextureUtils.pushTexture((String)"textures/atlas/blocks.png");
            MuseIconUtils.drawIconAt((double)(this.left() + 6.0), (double)(this.top() + 3.0), (TextureAtlasSprite)this.module.getIcon(null), (Colour)Colour.WHITE);
            MuseTextureUtils.popTexture();
            this.checkbox.render(mouseX, mouseY, partialTicks);
            this.button.label = KeybindingFrame.this.keybindingToRemap != null && KeybindingFrame.this.keybindingToRemap == this.kb ? ChatFormatting.YELLOW + "> " + ChatFormatting.WHITE + this.kb.getDisplayName() + ChatFormatting.YELLOW + " <" : (this.keyCodeModifierConflict() ? ChatFormatting.RED : ChatFormatting.WHITE) + this.kb.getDisplayName();
            this.button.render(mouseX, mouseY, partialTicks);
        }

        boolean keyCodeModifierConflict() {
            return false;
        }

        public void update(double mousex, double mousey) {
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.containsPoint(mouseX, mouseY)) {
                return this.checkbox.mouseClicked(mouseX, mouseY, button) || this.button.mouseClicked(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.checkbox.mouseReleased(mouseX, mouseY, button) || this.button.mouseReleased(mouseX, mouseY, button);
        }

        public List<String> getToolTip(double mouseX, double mouseY) {
            if (this.checkbox.containsPoint(mouseX, mouseY)) {
                return Arrays.asList(I18n.func_74838_a((String)"gui.powersuits.showOnHud"));
            }
            return null;
        }
    }
}

