/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.cosmetic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.modelspec.ModelRegistry;
import net.machinemuse.numina.client.render.modelspec.SpecBase;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.powersuits.client.gui.common.ItemSelectionFrame;
import net.machinemuse.powersuits.client.gui.cosmetic.ColourPickerFrame;
import net.machinemuse.powersuits.client.gui.cosmetic.PartSpecManipSubFrame;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PartManipContainer
extends ScrollableFrame {
    public ItemSelectionFrame itemSelect;
    public ColourPickerFrame colourSelect;
    public MusePoint2D topleft;
    public MusePoint2D bottomright;
    public Integer lastItemSlot;
    public int lastColour;
    public int lastColourIndex;
    public List<PartSpecManipSubFrame> modelframes;
    protected boolean enabled;
    protected boolean visibile;

    public PartManipContainer(ItemSelectionFrame itemSelect, ColourPickerFrame colourSelect, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        super((IRect)new DrawableMuseRect(topleft, bottomright, borderColour, insideColour));
        this.itemSelect = itemSelect;
        this.colourSelect = colourSelect;
        this.topleft = topleft;
        this.bottomright = bottomright;
        this.lastItemSlot = null;
        this.lastColour = this.getColour();
        this.lastColourIndex = this.getColourIndex();
        this.modelframes = this.getModelframes();
        this.enabled = true;
        this.visibile = true;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemSelect.getSelectedItem() != null ? this.itemSelect.getSelectedItem().getItem() : ItemStack.field_190927_a;
    }

    @Nullable
    public Integer getItemSlot() {
        return this.itemSelect.getSelectedItem() != null ? Integer.valueOf(this.itemSelect.getSelectedItem().inventorySlot) : null;
    }

    public int getColour() {
        if (this.getItem() == null) {
            return Colour.WHITE.getInt();
        }
        if (this.colourSelect.selectedColour < this.colourSelect.colours().length && this.colourSelect.selectedColour >= 0) {
            return this.colourSelect.colours()[this.colourSelect.selectedColour];
        }
        return Colour.WHITE.getInt();
    }

    public int getColourIndex() {
        return this.colourSelect.selectedColour;
    }

    public List<PartSpecManipSubFrame> getModelframes() {
        ArrayList<PartSpecManipSubFrame> modelframesList = new ArrayList<PartSpecManipSubFrame>();
        Iterable specCollection = ModelRegistry.getInstance().getSpecs();
        PartSpecManipSubFrame prev = null;
        for (SpecBase modelspec : specCollection) {
            PartSpecManipSubFrame newframe;
            prev = newframe = this.createNewFrame(modelspec, prev);
            modelframesList.add(newframe);
        }
        return modelframesList;
    }

    public PartSpecManipSubFrame createNewFrame(SpecBase modelspec, PartSpecManipSubFrame prev) {
        MuseRect newborder = new MuseRect(this.topleft.getX() + 4.0, this.topleft.getY() + 4.0, this.bottomright.getX(), this.topleft.getY() + 10.0);
        newborder.setBelow((IRect)(prev != null ? prev.border : null));
        return new PartSpecManipSubFrame(modelspec, this.colourSelect, this.itemSelect, newborder);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.enabled && button == 0) {
            for (PartSpecManipSubFrame frame : this.modelframes) {
                if (!frame.mouseClicked(mouseX, mouseY + this.currentScrollPixels)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        if (this.enabled) {
            if (!Objects.equals(this.lastItemSlot, this.getItemSlot())) {
                this.lastItemSlot = this.getItemSlot();
                this.colourSelect.refreshColours();
                double x = 0.0;
                for (PartSpecManipSubFrame subframe : this.modelframes) {
                    subframe.updateItems();
                    x += subframe.border.bottom();
                }
                this.totalSize = (int)x;
            }
            if (this.colourSelect.decrAbove > -1) {
                this.decrAbove(this.colourSelect.decrAbove);
                this.colourSelect.decrAbove = -1;
            }
        }
    }

    public void hide() {
        this.visibile = false;
    }

    public void show() {
        this.visibile = true;
    }

    public boolean isVisible() {
        return this.visibile;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void decrAbove(int index) {
        for (PartSpecManipSubFrame frame : this.modelframes) {
            frame.decrAbove(index);
        }
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.visibile) {
            super.preRender(mouseX, mouseY, partialTicks);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(-this.currentScrollPixels), (double)0.0);
            for (PartSpecManipSubFrame f : this.modelframes) {
                f.drawPartial(this.currentScrollPixels + 4.0 + this.top(), this.currentScrollPixels + this.bottom() - 4.0);
            }
            GL11.glPopMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }
}

