/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.network.packets;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.client.gui.GuiChocoboInventory;
import net.chococraft.common.entities.EntityChocobo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketOpenChocoboGui
implements IMessage {
    public int entityId;
    public int windowId;
    public NBTTagCompound saddle;
    @Nullable
    public NBTTagCompound inventory;

    public PacketOpenChocoboGui() {
    }

    public PacketOpenChocoboGui(EntityChocobo chocobo, int windowId) {
        this.entityId = chocobo.func_145782_y();
        this.windowId = windowId;
        this.saddle = chocobo.saddleItemStackHandler.serializeNBT();
        if (chocobo.getSaddleType().getInventorySize() > 0) {
            this.inventory = chocobo.chocoboInventory.serializeNBT();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.windowId = buf.readInt();
        this.saddle = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.inventory = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.windowId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.saddle);
        buf.writeBoolean(this.inventory != null);
        if (this.inventory != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.inventory);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketOpenChocoboGui, IMessage> {
        @Nullable
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketOpenChocoboGui message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                Entity entity = mc.field_71441_e.func_73045_a(message.entityId);
                if (!(entity instanceof EntityChocobo)) {
                    Chococraft.log.warn("Server send OpenGUI for chocobo with id {}, but this entity does not exist on my side", (Object)message.entityId);
                    return;
                }
                EntityChocobo chocobo = (EntityChocobo)entity;
                mc.func_147108_a((GuiScreen)new GuiChocoboInventory(chocobo, (EntityPlayer)mc.field_71439_g));
                mc.field_71439_g.field_71070_bA.field_75152_c = message.windowId;
                chocobo.saddleItemStackHandler.deserializeNBT(message.saddle);
                if (message.inventory != null) {
                    chocobo.chocoboInventory.deserializeNBT(message.inventory);
                }
            });
            return null;
        }
    }
}

