/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.properties;

import java.util.Optional;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public enum ChocoboColor {
    YELLOW((Ingredient)new OreIngredient("dyeYellow")),
    GREEN((Ingredient)new OreIngredient("dyeLime")),
    BLUE((Ingredient)new OreIngredient("dyeBlue")),
    WHITE((Ingredient)new OreIngredient("dyeWhite")),
    BLACK((Ingredient)new OreIngredient("dyeBlack")),
    GOLD((Ingredient)new OreIngredient("ingotGold")),
    PINK((Ingredient)new OreIngredient("dyePink")),
    RED((Ingredient)new OreIngredient("dyeRed")),
    PURPLE((Ingredient)new OreIngredient("dyePurple")),
    FLAME((Ingredient)new OreIngredient(""));

    private static Random rand;
    private Ingredient colorIngredient;

    private ChocoboColor(Ingredient colorIngredient) {
        this.colorIngredient = colorIngredient;
    }

    public static ChocoboColor getRandomColor() {
        return ChocoboColor.values()[rand.nextInt(ChocoboColor.values().length)];
    }

    public static Optional<ChocoboColor> getColorForItemstack(ItemStack itemStack) {
        for (ChocoboColor color : ChocoboColor.values()) {
            if (!color.colorIngredient.apply(itemStack)) continue;
            return Optional.of(color);
        }
        return Optional.empty();
    }

    static {
        rand = new Random();
    }
}

