/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.client.Texture;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public final class ImageCache {
    public static final ImageCache INSTANCE = new ImageCache();
    private final File cache;
    private Map<String, Texture> cacheMap = new HashMap<String, Texture>();

    private ImageCache() {
        this.cache = new File(Minecraft.func_71410_x().field_71412_D, "photo-frame-cache");
        this.cache.mkdir();
        this.init();
    }

    private void init() {
        try {
            FileUtils.writeStringToFile((File)new File(this.cache, "!read-me.txt"), (String)"This is a cache for GIFs that are played on the TV (in MrCrayfish's Furniture Mod) in order to speed up load time.\nIt is safe to delete the entire folder in case you are running out of space, however it will mean that all GIFs will have to be downloaded again.", (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Texture get(String url) {
        if (url == null) {
            return null;
        }
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Texture texture = this.cacheMap.get(url);
            if (texture != null) {
                return texture;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url, File file) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (!this.cacheMap.containsKey(url)) {
                Texture texture = new Texture(file);
                this.cacheMap.put(url, texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String url, byte[] data) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            try {
                if (!this.cacheMap.containsKey(url)) {
                    String id = DigestUtils.sha1Hex((byte[])url.getBytes());
                    File image = new File(this.getCache(), id);
                    FileUtils.writeByteArrayToFile((File)image, (byte[])data);
                    Texture texture = new Texture(image);
                    this.cacheMap.put(url, texture);
                    Minecraft.func_71410_x().func_152344_a(texture::update);
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            this.cacheMap.values().forEach(Texture::update);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadCached(String url) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.cacheMap.containsKey(url)) {
                return true;
            }
        }
        String id = DigestUtils.sha1Hex((byte[])url.getBytes());
        File file = new File(this.getCache(), id);
        if (file.exists()) {
            this.add(url, file);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(String url) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            return this.cacheMap.containsKey(url);
        }
    }

    public File getCache() {
        this.cache.mkdir();
        return this.cache;
    }
}

