/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class CharmHandler {
    public static Map<String, EnumEnchantmentType> enchantmentTypes = new HashMap<String, EnumEnchantmentType>();

    public CharmHandler() {
        block6: {
            try {
                if (ModConfig.server.charm.fixIncorrectItemEnchantments) {
                    this.fixIncorrectItemEnchantments();
                }
                if (ModConfig.server.charm.fixSalvageTrade) {
                    this.fixSalvageTrade();
                }
                if (ModConfig.server.charm.fixChargedEmeraldCrash) {
                    this.fixChargedEmeraldCrash();
                }
                if (ModConfig.server.charm.disableMagneticEnchantment) {
                    RLTweaker.logger.info("Disabling the Magnetic enchantment");
                    CompatUtil.findAndRemoveHandlerFromEventBus("svenhjol.charm.enchanting.feature.Magnetic");
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup CharmHandler!", (Throwable)e);
                ErrorUtil.logSilent("Charm Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block6;
                throw new RuntimeException(e);
            }
        }
    }

    private void fixChargedEmeraldCrash() {
        boolean replace = false;
        Item itemRef = null;
        for (Item item : BlockDispenser.field_149943_a.func_148742_b()) {
            if (item == null || !item.getClass().getName().equals("svenhjol.charm.world.item.ItemChargedEmerald")) continue;
            itemRef = item;
            replace = true;
            break;
        }
        if (replace) {
            RLTweaker.logger.info("Fixing Charged Emerald Crash");
            try {
                Class<?> c_EntityChargedEmerald = Class.forName("svenhjol.charm.world.entity.EntityChargedEmerald");
                final Constructor<?> con_EntityChargedEmerald = c_EntityChargedEmerald.getDeclaredConstructor(World.class);
                BlockDispenser.field_149943_a.func_82595_a((Object)itemRef, (Object)new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World world, IPosition position, ItemStack stack) {
                        try {
                            EntityThrowable throwable = (EntityThrowable)con_EntityChargedEmerald.newInstance(world);
                            throwable.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                            return throwable;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                            ErrorUtil.logSilent("Charm Charged Emerald Construction");
                            return new EntitySnowball(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                        }
                    }
                });
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                ErrorUtil.logSilent("Charm Charged Emerald Invocation");
                BlockDispenser.field_149943_a.func_82595_a((Object)itemRef, (Object)new BehaviorDefaultDispenseItem());
            }
        }
    }

    private void fixIncorrectItemEnchantments() {
        this.fixEnchantmentWithPredicate("curse_break", (Predicate<Item>)((Predicate)item -> false));
        this.fixEnchantmentWithPredicate("homing", (Predicate<Item>)((Predicate)item -> item == Items.field_151019_K || item == Items.field_151012_L || item == Items.field_151013_M));
        this.fixEnchantmentWithPredicate("magnetic", (Predicate<Item>)((Predicate)item -> item == Items.field_151097_aZ || item instanceof ItemTool));
    }

    private void fixEnchantmentWithType(String enchantName, EnumEnchantmentType type) {
        Enchantment enchant = this.getEnchantmentByName(enchantName);
        if (enchant == null) {
            ErrorUtil.logSilent("Charm Missing Enchantment " + enchantName);
            RLTweaker.logger.warn("Couldn't find Charm enchantment: " + enchantName);
        } else {
            enchant.field_77351_y = type;
        }
    }

    private void fixEnchantmentWithPredicate(String enchantName, Predicate<Item> delegate) {
        Enchantment enchant = this.getEnchantmentByName(enchantName);
        if (enchant == null) {
            ErrorUtil.logSilent("Charm Missing Enchantment " + enchantName);
            RLTweaker.logger.warn("Couldn't find Charm enchantment: " + enchantName);
        } else {
            String typeName = "RLTweaker Charm " + enchantName;
            EnumEnchantmentType type = EnumHelper.addEnchantmentType((String)typeName, delegate);
            if (type == null) {
                ErrorUtil.logSilent("Charm addEnchantmentType " + typeName);
                RLTweaker.logger.error("Found Charm enchantment but addEnchantmentType failed: " + typeName);
            } else {
                enchantmentTypes.put(typeName, type);
                enchant.field_77351_y = type;
                RLTweaker.logger.info("Replaced " + enchantName + " enchantment type with " + typeName);
            }
        }
    }

    @Nullable
    private Enchantment getEnchantmentByName(String name) {
        return (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation("charm", name));
    }

    private void fixSalvageTrade() {
        Enchantment salvage = this.getEnchantmentByName("salvage");
        if (salvage == null) {
            try {
                Object o_VillagerRegistry_INSTANCE = ReflectUtil.findField(VillagerRegistry.class, "INSTANCE").get(null);
                RegistryNamespaced REGISTRY = (RegistryNamespaced)ReflectUtil.findField(VillagerRegistry.class, "REGISTRY").get(o_VillagerRegistry_INSTANCE);
                VillagerRegistry.VillagerProfession smithProfession = (VillagerRegistry.VillagerProfession)REGISTRY.func_82594_a((Object)new ResourceLocation("minecraft:smith"));
                VillagerRegistry.VillagerCareer genericSmith = smithProfession.getCareer(0);
                VillagerRegistry.VillagerCareer weaponSmith = smithProfession.getCareer(1);
                VillagerRegistry.VillagerCareer toolSmith = smithProfession.getCareer(2);
                Field f_VillagerCareer_trades = ReflectUtil.findField(VillagerRegistry.VillagerCareer.class, "trades");
                this.removeAllSalvages((List)f_VillagerCareer_trades.get(genericSmith));
                this.removeAllSalvages((List)f_VillagerCareer_trades.get(weaponSmith));
                this.removeAllSalvages((List)f_VillagerCareer_trades.get(toolSmith));
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to remove Salvage trades", (Throwable)e);
                ErrorUtil.logSilent("Charm Salvage Trade Removal");
            }
        }
    }

    private void removeAllSalvages(List<List<EntityVillager.ITradeList>> trades) {
        for (List<EntityVillager.ITradeList> tradeLevel : trades) {
            Iterator<EntityVillager.ITradeList> iterator = tradeLevel.iterator();
            while (iterator.hasNext()) {
                EntityVillager.ITradeList tradeList = iterator.next();
                if (!tradeList.getClass().getName().equals("svenhjol.charm.world.feature.VillagerTrades$SalvageTrade")) continue;
                iterator.remove();
                RLTweaker.logger.info("Removed a charm salvage trade");
            }
        }
    }
}

