/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.helper.ASMHelper;
import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchFixOldGorgon
extends PatchManager {
    public PatchFixOldGorgon() {
        super("Old Gorgon");
        this.add(new Patch(this, "com.github.alexthe666.iceandfire.entity.EntityGorgon", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_onLivingUpdate = this.findMethod(clazzNode, "func_70636_d", "onLivingUpdate");
                if (m_onLivingUpdate == null) {
                    this.cancelled = true;
                    this.announce("Couldn't find func_70636_d or onLivingUpdate in EntityGorgon, skipping");
                    return;
                }
                FieldInsnNode soundField = TransformUtil.findNextFieldWithOpcodeAndName(this.first(m_onLivingUpdate), 178, "GORGON_ATTACK");
                if (soundField == null) {
                    this.cancelled = true;
                    this.announce("Couldn't find any GORGON_ATTACK in EntityGorgon, skipping");
                    return;
                }
                if (!soundField.owner.equals("com/github/alexthe666/iceandfire/core/ModSounds")) {
                    this.cancelled = true;
                    this.announce("GORGON_ATTACK was not owned by ModSounds in onLivingUpdate in EntityGorgon, skipping");
                    return;
                }
                AbstractInsnNode anchor = ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)soundField, 187);
                if (anchor instanceof TypeInsnNode) {
                    if (!((TypeInsnNode)anchor).desc.equals("com/github/alexthe666/iceandfire/entity/EntityStoneStatue")) {
                        this.cancelled = true;
                        this.announce("First instantiation found was not EntityStoneStatue in onLivingUpdate in EntityGorgon, patcher is confused, skipping");
                        return;
                    }
                } else {
                    this.cancelled = true;
                    this.announce("Couldn't find an instantiation at all in onLivingUpdate in EntityGorgon, skipping");
                    return;
                }
                String fName_rltweakerGorgonDelay = "rltweakerGorgonDelay";
                FieldNode fNode_rltweakerGorgonDelay = new FieldNode(1, fName_rltweakerGorgonDelay, "I", null, null);
                clazzNode.fields.add(fNode_rltweakerGorgonDelay);
                MethodInsnNode huntSuper = TransformUtil.findNextCallWithOpcodeAndName(this.first(m_onLivingUpdate), 183, "func_70636_d", "onLivingUpdate");
                if (huntSuper == null) {
                    throw new RuntimeException("Couldn't find super call in onLivingUpdate in EntityGorgon");
                }
                InsnList inject = new InsnList();
                inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                inject.add((AbstractInsnNode)new FieldInsnNode(180, "com/github/alexthe666/iceandfire/entity/EntityGorgon", fName_rltweakerGorgonDelay, "I"));
                inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/charles445/rltweaker/hook/HookIAF", "decrementToZero", "(I)I", false));
                inject.add((AbstractInsnNode)new FieldInsnNode(181, "com/github/alexthe666/iceandfire/entity/EntityGorgon", fName_rltweakerGorgonDelay, "I"));
                this.insert(m_onLivingUpdate, (AbstractInsnNode)huntSuper, inject);
                anchor = TransformUtil.findNextCallWithOpcodeAndName(anchor, 182, "func_72838_d", "spawnEntity");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find func_72838_d or spawnEntity in onLivingUpdate in EntityGorgon");
                }
                anchor = this.next(anchor, 2);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                AbstractInsnNode hookLocation = anchor;
                anchor = TransformUtil.findNextCallWithOpcodeAndName(anchor, 182, "func_70106_y", "setDead");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find func_70106_y or setDead in onLivingUpdate in EntityGorgon");
                }
                anchor = anchor.getNext();
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                anchor = TransformUtil.findNextFieldWithOpcodeAndName(anchor, 178, "gorgon");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find getstatic for gorgon in onLivingUpdate in EntityGorgon");
                }
                anchor = this.next(anchor, 4);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                this.removePreviousInsn(m_onLivingUpdate, anchor);
                for (int i = 0; i < 25; ++i) {
                    this.removePreviousInsn(m_onLivingUpdate, anchor);
                }
                LocalVariableNode lvn_statue = TransformUtil.findLocalVariableWithName(m_onLivingUpdate, "statue");
                if (lvn_statue == null) {
                    throw new RuntimeException("Couldn't find local variable statue in onLivingUpdate in EntityGorgon");
                }
                InsnList inject2 = new InsnList();
                inject2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                inject2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                inject2.add((AbstractInsnNode)new VarInsnNode(25, lvn_statue.index));
                inject2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                inject2.add((AbstractInsnNode)new FieldInsnNode(180, "com/github/alexthe666/iceandfire/entity/EntityGorgon", fName_rltweakerGorgonDelay, "I"));
                inject2.add((AbstractInsnNode)new FieldInsnNode(178, "com/github/alexthe666/iceandfire/IceAndFire", "gorgon", "Lnet/minecraft/util/DamageSource;"));
                inject2.add((AbstractInsnNode)new MethodInsnNode(184, "com/charles445/rltweaker/hook/HookIAF", "handleOldGorgon", "(Lnet/minecraft/entity/monster/EntityMob;Lnet/minecraft/entity/EntityLiving;ILnet/minecraft/util/DamageSource;)I", false));
                inject2.add((AbstractInsnNode)new FieldInsnNode(181, "com/github/alexthe666/iceandfire/entity/EntityGorgon", fName_rltweakerGorgonDelay, "I"));
                this.insert(m_onLivingUpdate, hookLocation, inject2);
            }
        });
    }
}

