/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.generator.tile.TileEntityThermalGenerator;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThermalGenComp
extends GuiComponent {
    TileEntityThermalGenerator thermal;

    public ThermalGenComp(TileEntityThermalGenerator tile) {
        super(Ic2GuiComp.nullBox);
        this.thermal = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        if (this.thermal.heatPoints > 0) {
            gui.func_73729_b(gui.getXOffset() + 66, gui.getYOffset() + 36, 176, 31, 14, 16);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString(Ic2GuiLang.thermalAmbientHeat, 10, 36, 0x404040);
        gui.drawString(Ic2GuiLang.thermalAmbientEU, 10, 44, 0x404040);
        gui.drawString(ItemStack.field_111284_a.format(this.getProduction()), 10, 52, 0x404040);
    }

    private float getProduction() {
        if (this.thermal.heatPoints <= 0) {
            return 0.0f;
        }
        float result = (float)this.thermal.heatPoints / (2000.0f * this.thermal.passiveConfig);
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }
}

