/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.container;

import ic2.core.block.machine.med.TileEntityCropHarvester;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.components.base.MachineChargeComp;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.inventory.slots.SlotExtract;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.misc.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ContainerCropHarvester
extends ContainerTileComponent<TileEntityCropHarvester> {
    public ContainerCropHarvester(InventoryPlayer player, TileEntityCropHarvester crop) {
        super(crop);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.func_75146_a(new SlotExtract(crop, x + y * 3, 63 + 18 * x, 14 + y * 18));
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a(new UpgradeSlot(crop.inv, i, 152, 8 + 18 * i, crop));
        }
        this.func_75146_a(new UpgradeSlot(crop.inv, 4, 134, 62, crop));
        this.addPlayerInventory(player);
        this.addComponent(new MachineChargeComp(crop, Ic2GuiComp.cropHarvesterChargeBox, Ic2GuiComp.machineChargePos));
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.cropHarvester;
    }

    @Override
    public int guiInventorySize() {
        return 14;
    }

    public static class UpgradeSlot
    extends SlotBase {
        TileEntityCropHarvester harvester;

        public UpgradeSlot(IHasInventory inv, int index, int xPosition, int yPosition, TileEntityCropHarvester tile) {
            super(inv, index, xPosition, yPosition);
            this.harvester = tile;
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.overClockerUpgrade)) {
                return true;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeBasicFieldUpgrade)) {
                return true;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeFieldUpgrade)) {
                return true;
            }
            return StackUtil.isStackEqual(stack, Ic2Items.padUpgradeAdvFieldUpgrade);
        }

        @Override
        public void func_75218_e() {
            this.harvester.setOverclockerUpgrade();
            super.func_75218_e();
        }
    }
}

