/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import com.google.common.math.DoubleMath;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.wind.IWindHandler;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.generator.container.ContainerWindMill;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.Box2D;
import java.math.RoundingMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityWindGenerator
extends TileEntityGeneratorBase {
    public static AabbUtil.IBlockFilter airFilter = new AirFilter();
    public int airBlocks;
    public int ticker;
    @NetworkField(index=7)
    public double subProduction;
    public double subStorage;
    public double configModifier = (double)IC2.config.getInt("energyGeneratorWind") / 100.0;

    public TileEntityWindGenerator() {
        super(1);
        this.production = DoubleMath.roundToInt((double)(16.0 * this.configModifier), (RoundingMode)RoundingMode.UP);
        this.maxStorage = DoubleMath.roundToInt((double)(32.0 * this.configModifier), (RoundingMode)RoundingMode.UP);
        this.ticker = random.nextInt(128);
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotsForSide(RotationList.VERTICAL, 0);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerWindMill(player.field_71071_by, this);
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return false;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.nullBox;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.windMill;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.windMill;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return Ic2Sounds.windmillLoop;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateAirBlocks();
    }

    public int getFuelLevel() {
        int result = (int)(this.subProduction / 4.0 * 14.0);
        if (result > 14) {
            return 14;
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getOverheatLevel() {
        if (this.subProduction < 4.0) {
            return 0;
        }
        if (this.subProduction >= 10.0) {
            return 14;
        }
        return (int)((this.subProduction - 4.0) / 4.0 * 14.0);
    }

    @Override
    public boolean gainEnergy() {
        ++this.ticker;
        if (this.ticker % 128 == 0) {
            if (this.ticker % 1024 == 0) {
                this.updateAirBlocks();
            }
            EnumFacing facing = this.getFacing();
            float angle = 90.0f;
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                angle = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 0.0f : 180.0f;
                facing = EnumFacing.NORTH;
            }
            IWindHandler handler = IC2.windManager.getHanlderFromWorld(this.func_145831_w());
            this.subProduction = Math.abs(handler.getWindStrenght(this.func_174877_v(), facing.func_176736_b(), angle) / handler.getMaxWind()) * 3.75;
            this.subProduction *= (double)this.airBlocks / 525.0;
            this.subProduction *= this.configModifier;
            if (this.field_145850_b.field_73011_w.func_191066_m()) {
                if (this.field_145850_b.func_72911_I()) {
                    this.subProduction *= 1.8;
                } else if (this.field_145850_b.func_72896_J()) {
                    this.subProduction *= 1.2;
                }
            }
            if (this.subProduction < 0.0) {
                this.subProduction = 0.0;
                this.getNetwork().updateTileGuiField(this, "subProduction");
                return false;
            }
            this.getNetwork().updateTileGuiField(this, "subProduction");
        }
        if (this.subProduction == 0.0) {
            return false;
        }
        this.subStorage += this.subProduction * 4.0;
        if (this.subStorage >= 1.0) {
            this.production = (int)this.subStorage;
            this.storage += this.production;
            this.subStorage -= (double)this.production;
            if (this.storage > this.maxStorage) {
                this.storage = this.maxStorage;
            }
            return true;
        }
        return false;
    }

    public void updateAirBlocks() {
        this.airBlocks = AabbUtil.getBlockCount(this.func_145831_w(), this.func_174877_v(), new AabbUtil.BoundingBox(-4, -2, -4, 4, 4, 4).applyOffset(this.func_174877_v()), airFilter, true, false, RotationList.ALL);
    }

    public static class AirFilter
    implements AabbUtil.IBlockFilter {
        @Override
        public boolean isValidBlock(IBlockState state) {
            return state.func_177230_c() == Blocks.field_150350_a;
        }

        @Override
        public boolean isValidBlock(World world, BlockPos pos) {
            return world.func_175623_d(pos);
        }

        @Override
        public boolean forceChunkLoad() {
            return false;
        }
    }
}

