/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.plugin;

import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.bridge.fml.common.LoaderBridge;
import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import io.github.lxgaming.sledgehammer.mixin.forge.fml.common.MetadataCollectionAccessor;
import io.github.lxgaming.sledgehammer.mixin.plugin.CorePlugin;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.ModList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class ForgePlugin
extends CorePlugin {
    private static boolean INITIALIZED;

    @Override
    public void onLoad(String mixinPackage) {
        super.onLoad(mixinPackage);
        if (MixinEnvironment.getCurrentEnvironment().getPhase() != MixinEnvironment.Phase.DEFAULT) {
            return;
        }
        if (INITIALIZED || SledgehammerLaunch.isDeobfuscatedEnvironment() || !SledgehammerLaunch.isForgeInitialized() || !SledgehammerLaunch.isSledgehammerInitialized() || MappingManager.MOD_MAPPINGS.isEmpty()) {
            return;
        }
        INITIALIZED = true;
        if (!MappingManager.getMixinMapping("forge.fml.common.LoaderMixin").orElse(false).booleanValue()) {
            Sledgehammer.getInstance().getLogger().error("LoaderMixin is disabled");
            return;
        }
        if (!MappingManager.getMixinMapping("forge.fml.common.MetadataCollectionAccessor").orElse(false).booleanValue()) {
            Sledgehammer.getInstance().getLogger().error("MetadataCollectionAccessor is disabled");
            return;
        }
        LoaderBridge loaderBridge = (LoaderBridge)Loader.instance();
        LinkedHashSet files = Sets.newLinkedHashSet();
        files.addAll(LibraryManager.gatherLegacyCanidates((File)loaderBridge.bridge$getMinecraftDirectory()));
        ModList.getBasicLists((File)loaderBridge.bridge$getMinecraftDirectory()).stream().map(ModList::getArtifacts).flatMap(Collection::stream).map(Artifact::getFile).forEach(files::add);
        for (File file : files) {
            Set<String> ids = this.getModIds(file);
            if (ids == null || ids.isEmpty()) {
                Sledgehammer.getInstance().getLogger().debug("{}: No metadata", (Object)file.getName());
                continue;
            }
            loaderBridge.bridge$getMappings().computeIfAbsent(file, key -> Sets.newHashSet());
            Sledgehammer.getInstance().getLogger().debug("{}:", (Object)file.getName());
            for (String id : ids) {
                if (loaderBridge.bridge$getMappings().get(file).add(id)) {
                    Sledgehammer.getInstance().getLogger().debug("- {}", (Object)id);
                    continue;
                }
                Sledgehammer.getInstance().getLogger().debug("- {} (Duplicate)", (Object)id);
            }
        }
        int size = loaderBridge.bridge$getMappings().size();
        Sledgehammer.getInstance().getLogger().info("Identified {} {}", (Object)size, (Object)Toolbox.formatUnit(size, "mod", "mods"));
        for (Map.Entry<String, Boolean> entry : MappingManager.MOD_MAPPINGS.entrySet()) {
            File file = this.getFile(entry.getKey());
            if (file == null) continue;
            if (entry.getValue().booleanValue()) {
                if (CoreModManager.getIgnoredMods().removeIf(file.getName()::equals)) {
                    Sledgehammer.getInstance().getLogger().info("Acknowledged {}", (Object)file.getName());
                }
                loaderBridge.bridge$addFile(file);
                continue;
            }
            if (CoreModManager.getIgnoredMods().contains(file.getName())) continue;
            CoreModManager.getIgnoredMods().add(file.getName());
            Sledgehammer.getInstance().getLogger().info("Ignored {}", (Object)file.getName());
        }
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!SledgehammerLaunch.isForgeInitialized()) {
            return false;
        }
        return super.shouldApplyMixin(targetClassName, mixinClassName);
    }

    private File getFile(String id) {
        LoaderBridge loaderBridge = (LoaderBridge)Loader.instance();
        for (Map.Entry<File, Set<String>> entry : loaderBridge.bridge$getMappings().entrySet()) {
            if (!StringUtils.containsIgnoreCase((Collection<String>)entry.getValue(), id)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Set<String> getModIds(File file) {
        Map<String, ModMetadata> metadatas = this.getMetadataCollection(file).accessor$getMetadatas();
        if (metadatas.isEmpty()) {
            return null;
        }
        metadatas.keySet().removeIf(key -> key == null || key.equals("examplemod"));
        if (!metadatas.isEmpty()) {
            return metadatas.keySet();
        }
        AnnotationNode annotationNode = this.getModAnnotation(file);
        if (annotationNode == null) {
            return null;
        }
        String id = this.parseModAnnotation(annotationNode);
        if (id != null) {
            return Sets.newHashSet((Object[])new String[]{id});
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private MetadataCollectionAccessor getMetadataCollection(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnnotationNode getModAnnotation(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    ClassNode classNode = new ClassNode();
                    ClassReader classReader = new ClassReader(inputStream);
                    classReader.accept((ClassVisitor)classNode, 7);
                    if (classNode.visibleAnnotations == null || classNode.visibleAnnotations.isEmpty()) continue;
                    for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
                        if (!annotationNode.desc.equals("Lnet/minecraftforge/fml/common/Mod;")) continue;
                        AnnotationNode annotationNode2 = annotationNode;
                        return annotationNode2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            AnnotationNode annotationNode = null;
            return annotationNode;
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while getting annotation from {}", (Object)file, (Object)ex);
            return null;
        }
    }

    private String parseModAnnotation(AnnotationNode annotationNode) {
        List values = annotationNode.values;
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (int index = 0; index < values.size(); ++index) {
            Object value = values.get(index);
            if (!(value instanceof String) || !value.equals("modid")) continue;
            return (String)values.get(index + 1);
        }
        return null;
    }
}

