/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModOptions;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 17;
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private IXaeroMinimap modMain;
    private int destinationCaving = -1;
    private long lastDestinationCavingSwitch;
    private int previousRenderedCaveLayer = Integer.MAX_VALUE;
    private int lastRenderedCaveLayer = Integer.MAX_VALUE;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(XaeroMinimapSession minimapSession, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                EntityPlayerSP player;
                String worldString;
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                int compatibilityVersion = this.compatibilityVersion;
                String string = worldString = compatibilityVersion >= 7 ? mapProcessor.getCurrentWorldId() : mapProcessor.getCurrentWorldString();
                if (worldString == null) {
                    return;
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                boolean wmHasCaveLayers = this.hasCaveLayers();
                boolean wmUsesHashcodes = compatibilityVersion >= 5;
                int globalRegionCacheHashCode = wmUsesHashcodes ? WorldMap.settings.getRegionCacheHashCode() : 0;
                boolean reloadEverything = wmUsesHashcodes ? WorldMap.settings.reloadEverything : false;
                int globalReloadVersion = wmUsesHashcodes ? WorldMap.settings.reloadVersion : 0;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
                if (wmHasCaveLayers) {
                    mapProcessor.updateCaveStart();
                }
                int renderedCaveLayer = wmHasCaveLayers ? mapProcessor.getCurrentCaveLayer() : 0;
                int globalCaveStart = wmHasCaveLayers ? mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(renderedCaveLayer).getCaveStart() : 0;
                int globalCaveDepth = wmHasCaveLayers ? WorldMap.settings.caveModeDepth : 0;
                float brightness = this.getMinimapBrightness();
                if (renderedCaveLayer != this.lastRenderedCaveLayer) {
                    this.previousRenderedCaveLayer = this.lastRenderedCaveLayer;
                }
                boolean noCaveMaps = (player = Minecraft.func_71410_x().field_71439_g).func_70644_a(Effects.NO_CAVE_MAPS) || player.func_70644_a(Effects.NO_CAVE_MAPS_HARMFUL);
                boolean playerIsMoving = player.field_70169_q != player.field_70165_t || player.field_70167_r != player.field_70163_u || player.field_70166_s != player.field_70161_v;
                boolean shouldRequestLoading = true;
                LeveledRegion nextToLoadObj = null;
                if (compatibilityVersion >= 11) {
                    LeveledRegion nextToLoad;
                    shouldRequestLoading = false;
                    nextToLoadObj = nextToLoad = mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    if (nextToLoad != null) {
                        LeveledRegion leveledRegion = nextToLoad;
                        synchronized (leveledRegion) {
                            if (!(nextToLoad.reloadHasBeenRequested() || nextToLoad.hasRemovableSourceData() || nextToLoad instanceof MapRegion && ((MapRegion)nextToLoad).isRefreshing())) {
                                shouldRequestLoading = true;
                            }
                        }
                    } else {
                        shouldRequestLoading = true;
                    }
                    this.regionBuffer.clear();
                    if (wmHasCaveLayers) {
                        int comparisonChunkX = (MathHelper.func_76128_c((double)player.field_70165_t) >> 4) - 16;
                        int comparisonChunkZ = (MathHelper.func_76128_c((double)player.field_70161_v) >> 4) - 16;
                        LeveledRegion.setComparison((int)comparisonChunkX, (int)comparisonChunkZ, (int)0, (int)comparisonChunkX, (int)comparisonChunkZ);
                    } else {
                        int comparisonRegionX = MathHelper.func_76128_c((double)player.field_70165_t) >> 9;
                        int comparisonRegionZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 9;
                        LeveledRegion.setComparison((int)comparisonRegionX, (int)comparisonRegionZ, (int)0, (int)comparisonRegionX, (int)comparisonRegionZ);
                    }
                }
                if (compatibilityVersion >= 7) {
                    GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
                }
                if (compatibilityVersion >= 6) {
                    GuiMap.setupTextureMatricesAndTextures((float)brightness);
                }
                WaypointWorld world = minimapSession.getWaypointsManager().getAutoWorld();
                Long seed = !slimeChunks || world == null ? null : this.modMain.getSettings().getSlimeChunksSeed(world.getFullId());
                MapRegion prevRegion = null;
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        MapTileChunk previousLayerChunk;
                        MapRegion previousLayerRegion;
                        boolean chunkIsVisible;
                        MapRegion region = wmHasCaveLayers ? mapProcessor.getMapRegion(renderedCaveLayer, i >> 3, j >> 3, mapProcessor.regionExists(renderedCaveLayer, i >> 3, j >> 3)) : mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                        if (region != null && region != prevRegion) {
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                int regionReloadVersion;
                                int regionHashCode = wmUsesHashcodes ? region.getCacheHashCode() : 0;
                                int n = regionReloadVersion = wmUsesHashcodes ? region.getReloadVersion() : 0;
                                if (shouldRequestLoading && !region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (!(region instanceof MapRegion) || !region.isRefreshing()) && (region.getLoadState() == 0 || (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten()) && (reloadEverything && regionReloadVersion != globalReloadVersion || regionHashCode != globalRegionCacheHashCode || wmHasCaveLayers && !playerIsMoving && region.caveStartOutdated(globalCaveStart, globalCaveDepth) || region.getVersion() != mapProcessor.getGlobalVersion() || compatibilityVersion >= 11 && (region.isMetaLoaded() || region.getLoadState() != 0 || !region.hasHadTerrain()) && region.getHighlightsHash() != region.getDim().getHighlightHandler().getRegionHash(region.getRegionX(), region.getRegionZ()) || region.getLoadState() != 2 && region.shouldCache()))) {
                                    if (compatibilityVersion >= 11) {
                                        if (!this.regionBuffer.contains(region)) {
                                            if (wmHasCaveLayers) {
                                                region.calculateSortingChunkDistance();
                                            } else {
                                                region.calculateSortingDistance();
                                            }
                                            Misc.addToListOfSmallest((int)10, this.regionBuffer, (Comparable)region);
                                        }
                                    } else if (region.getLoadState() == 2) {
                                        region.requestRefresh(mapProcessor);
                                    } else if (shouldRequestLoading) {
                                        mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap", false);
                                        mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                                    }
                                }
                            }
                        }
                        prevRegion = region;
                        if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ) continue;
                        MapTileChunk chunk = region == null ? null : region.getChunk(i & 7, j & 7);
                        boolean bl = chunkIsVisible = chunk != null && chunk.getGlColorTexture() != -1;
                        if (!(!wmHasCaveLayers || chunkIsVisible || noCaveMaps && this.previousRenderedCaveLayer != Integer.MAX_VALUE || (previousLayerRegion = mapProcessor.getMapRegion(this.previousRenderedCaveLayer, i >> 3, j >> 3, false)) == null || (previousLayerChunk = previousLayerRegion.getChunk(i & 7, j & 7)) == null || previousLayerChunk.getGlColorTexture() == -1)) {
                            region = previousLayerRegion;
                            chunk = previousLayerChunk;
                            chunkIsVisible = true;
                        }
                        if (!chunkIsVisible) continue;
                        if (!mapProcessor.isUploadingPaused()) {
                            if (compatibilityVersion >= 7) {
                                if (region.isLoaded()) {
                                    if (wmHasCaveLayers) {
                                        mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(region);
                                    } else {
                                        mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(region);
                                    }
                                }
                            } else {
                                List regions = mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList();
                                regions.remove(region);
                                regions.add(region);
                            }
                        }
                        this.bindMapTextureWithLighting(compatibilityVersion, brightness, chunk, zooming);
                        if (zooming && compatibilityVersion >= 12) {
                            GlStateManager.func_179138_g((int)33984);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        }
                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                        int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                        int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                        if (compatibilityVersion < 7) {
                            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                            GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (int)0, (int)0, (float)64.0f, (float)64.0f);
                        } else {
                            GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (float)64.0f, (float)64.0f);
                        }
                        if (zooming && compatibilityVersion >= 12) {
                            GlStateManager.func_179138_g((int)33984);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                        }
                        if (slimeChunks) {
                            boolean newSeed;
                            GuiMap.restoreTextureStates();
                            if (compatibilityVersion >= 7) {
                                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                            }
                            Long savedSeed = seedsUsed.get(chunk);
                            boolean bl2 = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                            if (newSeed) {
                                seedsUsed.put(chunk, seed);
                            }
                            for (int t = 0; t < 16; ++t) {
                                if (newSeed || (chunk.getTileGridsCache()[t % 4][t / 4] & 1) == 0) {
                                    chunk.getTileGridsCache()[t % 4][t / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t % 4, chunk.getZ() * 4 + t / 4, seed) ? 2 : 0));
                                }
                                if ((chunk.getTileGridsCache()[t % 4][t / 4] & 2) == 0) continue;
                                int slimeDrawX = drawX + 16 * (t % 4);
                                int slimeDrawZ = drawZ + 16 * (t / 4);
                                Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                            }
                            if (compatibilityVersion >= 6) {
                                GuiMap.setupTextures((float)brightness);
                            }
                            if (compatibilityVersion >= 7) {
                                GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
                                GlStateManager.func_179147_l();
                            }
                        }
                        if (compatibilityVersion >= 7) continue;
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179147_l();
                    }
                }
                GuiMap.restoreTextureStates();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179084_k();
                this.lastRenderedCaveLayer = renderedCaveLayer;
                if (compatibilityVersion >= 11) {
                    int toRequest = 1;
                    int counter = 0;
                    for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                        MapRegion region = this.regionBuffer.get(i);
                        if (region == nextToLoadObj && this.regionBuffer.size() > 1) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region instanceof MapRegion && region.isRefreshing() || region.getLoadState() != 0 && region.getLoadState() != 4 && (region.getLoadState() != 2 || !region.isBeingWritten())) {
                                continue;
                            }
                            if (region.getLoadState() == 2) {
                                region.requestRefresh(mapProcessor);
                            } else {
                                mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap sorted", false);
                            }
                            if (counter == 0) {
                                mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion)region);
                            }
                            ++counter;
                            if (region.getLoadState() == 4) {
                                break;
                            }
                            continue;
                        }
                    }
                }
            }
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public int getWorldMapTerrainSlopes() {
        int wmSetting = WorldMap.settings.terrainSlopes;
        if (this.compatibilityVersion >= 5) {
            return wmSetting;
        }
        return wmSetting == 2 ? 3 : wmSetting;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        return WorldMap.settings.getClientBooleanValue(xaero.map.settings.ModOptions.IGNORE_HEIGHTMAPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldId(World world, int dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion >= 15) {
            Object object = mapProcessor.uiPauseSync;
            synchronized (object) {
                if (mapProcessor.isUIPaused()) {
                    return null;
                }
                return this.getMultiworldIdUnsynced(mapProcessor, world, dimId);
            }
        }
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            return this.getMultiworldIdUnsynced(mapProcessor, world, dimId);
        }
    }

    private String getMultiworldIdUnsynced(MapProcessor mapProcessor, World world, int dimId) {
        MapDimension mapDim;
        MapDimension mapDimension = mapDim = !mapProcessor.isMapWorldUsable() || mapProcessor.isWaitingForWorldUpdate() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(world, dimId);
        return mapDim == null ? null : (!mapDim.currentMultiworldWritable ? "minimap" : mapDim.getCurrentMultiworld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(World world, int dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(world, dimId);
            return mapDim == null || !mapProcessor.isWaitingForWorldUpdate() && mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIds(World world, int dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(world, dimId);
            return mapDim == null ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldName(int dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion >= 15) {
            Object object = mapProcessor.uiPauseSync;
            synchronized (object) {
                if (mapProcessor.isUIPaused()) {
                    return null;
                }
                return this.getMultiworldNameUnsynced(mapProcessor, dimId, multiworldId);
            }
        }
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            return this.getMultiworldNameUnsynced(mapProcessor, dimId, multiworldId);
        }
    }

    private String getMultiworldNameUnsynced(MapProcessor mapProcessor, int dimId, String multiworldId) {
        MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(null, dimId);
        return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
    }

    public void openSettings() {
        GuiScreen currentEscScreen;
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        GuiScreen guiScreen = currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        if (this.compatibilityVersion >= 8) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldMapSettings(current, currentEscScreen));
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldMapSettings(current));
        }
    }

    public float getMinimapBrightness() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return 1.0f;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion < 4) {
            return mapProcessor.getBrightness();
        }
        return mapProcessor.getBrightness(this.modMain.getSettings().getLighting());
    }

    private void bindMapTextureWithLighting(int compatibilityVersion, float brightness, MapTileChunk chunk, boolean zooming) {
        if (compatibilityVersion >= 12) {
            GuiMap.bindMapTextureWithLighting4((MapTileChunk)chunk, (int)0);
        } else if (compatibilityVersion >= 7) {
            GuiMap.bindMapTextureWithLighting3((MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        } else if (compatibilityVersion >= 6) {
            GuiMap.bindMapTextureWithLighting3((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        } else {
            GuiMap.bindMapTextureWithLighting((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        }
    }

    public boolean screenShouldSkipWorldRender(GuiScreen screen) {
        if (this.compatibilityVersion < 8) {
            return false;
        }
        return Misc.screenShouldSkipWorldRender((GuiScreen)screen, (boolean)false);
    }

    public boolean getAdjustHeightForCarpetLikeBlocks() {
        if (this.compatibilityVersion < 10) {
            return false;
        }
        return WorldMap.settings.adjustHeightForCarpetLikeBlocks;
    }

    public void registerHighlighters(HighlighterRegistry highlighterRegistry) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.registerMinimapHighlighters((Object)highlighterRegistry);
    }

    public void createRadarRenderWrapper(RadarRenderer radarRenderer) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.createRadarRendererWrapper((Object)radarRenderer);
    }

    public boolean worldMapIsRenderingRadar() {
        if (this.compatibilityVersion < 12) {
            return false;
        }
        return WorldMap.settings.minimapRadar;
    }

    public boolean usesPartialYFromWorldMap() {
        return this.compatibilityVersion >= 16;
    }

    public boolean getPartialYTeleport() {
        return WorldMap.settings.partialYTeleportation;
    }

    public boolean isStainedGlassDisplayed() {
        if (this.compatibilityVersion < 17) {
            return true;
        }
        return WorldMap.settings.displayStainedGlass;
    }

    public boolean hasCaveLayers() {
        return this.compatibilityVersion >= 19;
    }

    public boolean isMultiplayerMap() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getMapWorld().isMultiplayer();
    }

    public int getManualCaveStart() {
        return WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? -1 : WorldMap.settings.caveModeStart;
    }

    public boolean hasEnabledCaveLayers() {
        return this.getCaveModeType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaveModeType() {
        if (!this.hasCaveLayers() || !WorldMap.settings.isCaveMapsAllowed()) {
            return 0;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return WorldMap.settings.defaultCaveModeType;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiPauseSync;
        synchronized (object) {
            if (mapProcessor.isUIPaused()) {
                return WorldMap.settings.defaultCaveModeType;
            }
            MapDimension mapDim = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDim != null) {
                return mapDim.getCaveModeType();
            }
        }
        return WorldMap.settings.defaultCaveModeType;
    }

    public void openScreenForOption(ModOptions option) {
        GuiScreen currentEscScreen;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        GuiScreen guiScreen = currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        if (currentEscScreen instanceof GuiMap) {
            currentEscScreen = null;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        GuiMap screen = new GuiMap(current, currentEscScreen, mapProcessor, Minecraft.func_71410_x().func_175606_aa());
        if (option == ModOptions.MANUAL_CAVE_MODE_START) {
            screen.enableCaveModeOptions();
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
    }

    public int getCaveModeDepth() {
        if (!this.hasCaveLayers()) {
            return 30;
        }
        return WorldMap.settings.caveModeDepth;
    }

    public boolean isLegibleCaveMaps() {
        if (!this.hasCaveLayers()) {
            return false;
        }
        return WorldMap.settings.legibleCaveMaps;
    }

    public boolean hasBiomeBlendingOption() {
        return this.compatibilityVersion >= 20;
    }

    public boolean getBiomeBlending() {
        return WorldMap.settings.biomeBlending;
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 22;
    }

    public void confirmPlayerRadarRender(EntityPlayer e) {
        if (this.hasTrackedPlayerSystemSupport()) {
            if (WorldMap.trackedPlayerRenderer.getCollector().playerExists(e.func_110124_au())) {
                WorldMap.trackedPlayerRenderer.getCollector().confirmPlayerRadarRender(e);
            }
            return;
        }
    }
}

