/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import xaero.common.IXaeroMinimap;
import xaero.common.message.MinimapMessage;
import xaero.common.message.PacketConsumerForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandler {
    public static final int NETWORK_COMPATIBILITY = 1;
    private final IXaeroMinimap modMain;

    public MinimapMessageHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (serverHandler != null) {
            this.modMain.getNetwork().registerMessage(consumer, type, index, Side.SERVER);
        }
        if (clientHandler != null) {
            this.modMain.getNetwork().registerMessage(consumer, type, index, Side.CLIENT);
        }
    }

    public void sendToPlayer(EntityPlayerMP player, MinimapMessage<?> message) {
        this.modMain.getNetwork().sendTo(message, player);
    }

    public void sendToServer(MinimapMessage<?> message) {
        this.modMain.getNetwork().sendToServer(message);
    }
}

