/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiActionButton;
import xaero.common.gui.ICanTooltip;
import xaero.common.gui.IScreenBase;
import xaero.common.gui.MyOptionSlider;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.misc.Misc;

public class ScreenBase
extends GuiScreen
implements IScreenBase {
    protected IXaeroMinimap modMain;
    public GuiScreen parent;
    public GuiScreen escape;
    protected boolean canSkipWorldRender;
    protected int guiScaleFactor;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    protected boolean handledMouseInput;

    protected ScreenBase(IXaeroMinimap modMain, GuiScreen parent, GuiScreen escape) {
        this.modMain = modMain;
        this.parent = parent;
        this.escape = escape;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    protected void onExit(GuiScreen screen) {
        this.field_146297_k.func_147108_a(screen);
    }

    protected void goBack() {
        this.onExit(this.parent);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.onClose();
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.handledMouseInput = true;
        if (button instanceof GuiActionButton) {
            ((GuiActionButton)button).press();
            return;
        }
        super.func_146284_a(button);
    }

    public void renderEscapeScreen(int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.func_73863_a(p_230430_2_, p_230430_3_, p_230430_4_);
        }
        GlStateManager.func_179086_m((int)256);
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        super.func_73863_a(mouseX, mouseY, partial);
        this.renderPreDropdown(mouseX, mouseY, partial);
        if (this.openDropdown != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            this.openDropdown.render(mouseX, mouseY, this.field_146295_m, false);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
        this.guiScaleFactor = var3.func_78325_e();
        this.dropdowns.clear();
        this.openDropdown = null;
    }

    public void func_146280_a(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.func_146280_a(p_231158_1_, p_231158_2_, p_231158_3_);
        if (this.escape != null) {
            this.escape.func_146280_a(p_231158_1_, p_231158_2_, p_231158_3_);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown(mouseX, mouseY, this.field_146295_m)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.func_146116_c(this.field_146297_k, mouseX, mouseY);
                this.handledMouseInput = true;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    public void func_146274_d() throws IOException {
        this.handledMouseInput = false;
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            if (this.openDropdown != null && this.openDropdown.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) {
                this.openDropdown.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        if (this.openDropdown != null) {
            this.openDropdown.func_146118_a(mouseX, mouseY);
        }
        super.func_146286_b(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && Misc.screenShouldSkipWorldRender(this.modMain, this.escape, true);
    }

    protected boolean renderTooltips(int par1, int par2, float par3) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)2.1);
        boolean result = this.modMain.getWidgetScreenHandler().renderTooltips(this, this.field_146294_l, this.field_146295_m, par1, par2, this.guiScaleFactor);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            CursorBox tooltip;
            GuiButton b = (GuiButton)this.field_146292_n.get(k);
            boolean mousePressed = Mouse.isButtonDown((int)0);
            if (!(b instanceof ICanTooltip) || b instanceof MyOptionSlider && mousePressed) continue;
            ICanTooltip optionWidget = (ICanTooltip)b;
            if (par1 < b.field_146128_h || par2 < b.field_146129_i || par1 >= b.field_146128_h + b.field_146120_f || par2 >= b.field_146129_i + b.field_146121_g || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().apply(this.modMain)) == null) continue;
            tooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
            result = true;
            break;
        }
        GlStateManager.func_179121_F();
        return result;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected void addWidget(DropDownWidget guiEventListener) {
        this.dropdowns.add(guiEventListener);
        this.field_146292_n.add(guiEventListener);
    }

    public void replaceWidget(GuiButton current, GuiButton replacement) {
        int dropdownIndex;
        int buttonIndex = this.field_146292_n.indexOf(current);
        if (buttonIndex != -1) {
            this.field_146292_n.set(buttonIndex, replacement);
        }
        if ((dropdownIndex = this.dropdowns.indexOf(current)) != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
    }
}

