/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import java.nio.file.Path;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.message.basic.HandshakePacket;
import xaero.common.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.common.server.MinecraftServerData;
import xaero.common.server.MineraftServerDataInitializer;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.player.IServerPlayer;
import xaero.common.server.player.ServerPlayerData;

public class ForgeCommonEventHandler {
    private final IXaeroMinimap modMain;

    public ForgeCommonEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void register() {
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        if (oldPlayer instanceof EntityPlayerMP) {
            EntityPlayer newPlayer = event.getEntityPlayer();
            ((IServerPlayer)newPlayer).setXaeroMinimapPlayerData(ServerPlayerData.get((EntityPlayerMP)oldPlayer));
        }
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer(), this.modMain);
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            this.modMain.getMessageHandler().sendToPlayer((EntityPlayerMP)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(EntityPlayerMP player) {
        this.modMain.getMessageHandler().sendToPlayer(player, new HandshakePacket());
        MinecraftServer mcServer = player.field_70170_p.func_73046_m();
        Path propertiesPath = mcServer.func_71254_M().func_186352_b(mcServer.func_71270_I(), "xaeromap.txt").toPath();
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.func_184102_h());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            this.modMain.getMessageHandler().sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("gui.xaero_error_loading_properties", new Object[0]));
        }
    }
}

