/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.api.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class CAStacksBase
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected NonNullList<ItemStack> stacks;
    protected boolean[] isSkinArmor;

    public CAStacksBase() {
        this(4);
    }

    public CAStacksBase(int size) {
        this.setSize(size);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("CosArmor.Inventory.Size", 3) ? nbt.func_74762_e("CosArmor.Inventory.Size") : this.stacks.size());
        NBTTagList tagList = nbt.func_150295_c("CosArmor.Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new ItemStack(itemTags));
            this.isSkinArmor[slot] = itemTags.func_74767_n("isSkinArmor");
        }
        this.onLoad();
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public boolean isSkinArmor(int slot) {
        this.validateSlotIndex(slot);
        return this.isSkinArmor[slot];
    }

    protected void onContentsChanged(int slot) {
    }

    protected void onLoad() {
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) {
                ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            }
            itemTag.func_74757_a("isSkinArmor", this.isSkinArmor[i]);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("CosArmor.Inventory", (NBTBase)nbtTagList);
        nbt.func_74768_a("CosArmor.Inventory.Size", this.stacks.size());
        return nbt;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.isSkinArmor = new boolean[size];
    }

    public void setSkinArmor(int slot, boolean enabled) {
        this.validateSlotIndex(slot);
        if (this.isSkinArmor[slot] == enabled) {
            return;
        }
        this.isSkinArmor[slot] = enabled;
        this.onContentsChanged(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack)) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }
}

