/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.silvercatcher.reforged.ReforgedReferences;
import org.silvercatcher.reforged.entities.EntityBoomerang;
import org.silvercatcher.reforged.material.MaterialManager;
import org.silvercatcher.reforged.models.ModelBoomerang;
import org.silvercatcher.reforged.render.ReforgedRender;

@SideOnly(value=Side.CLIENT)
public class RenderBoomerang
extends ReforgedRender<EntityBoomerang> {
    public RenderBoomerang(RenderManager renderManager) {
        super(renderManager, new ModelBoomerang(), 90);
    }

    protected ResourceLocation getEntityTexture(EntityBoomerang entity) {
        if (entity.getMaterialDefinition() == null) {
            return ReforgedReferences.Textures.WOODEN_BOOMERANG;
        }
        switch (entity.getMaterialDefinition().getPrefix()) {
            case "diamond": {
                return ReforgedReferences.Textures.DIAMOND_BOOMERANG;
            }
            case "golden": {
                return ReforgedReferences.Textures.GOLDEN_BOOMERANG;
            }
            case "iron": {
                return ReforgedReferences.Textures.IRON_BOOMERANG;
            }
            case "stone": {
                return ReforgedReferences.Textures.STONE_BOOMERANG;
            }
            case "wooden": {
                return ReforgedReferences.Textures.WOODEN_BOOMERANG;
            }
        }
        if (MaterialManager.isFullyAdded(entity.getMaterialDefinition().getMaterial())) {
            return MaterialManager.getTextures(entity.getMaterialDefinition().getMaterial())[0];
        }
        return ReforgedReferences.Textures.WOODEN_BOOMERANG;
    }

    @Override
    public void renderEntityModel(EntityBoomerang theEntity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        this.func_110776_a(this.getEntityTexture(theEntity));
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glRotatef((float)(theEntity.field_70126_B + (theEntity.field_70177_z - theEntity.field_70126_B) * partialTick - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.func_78088_a((Entity)theEntity, (float)x, (float)y, (float)z, yaw, partialTick, 0.0475f);
        GL11.glPopMatrix();
    }
}

