/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.TSPAlgorithm;
import org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class TwoApproxMetricTSP<V, E>
implements TSPAlgorithm<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        if (!graph.getType().isUndirected()) {
            throw new IllegalArgumentException("Graph must be undirected");
        }
        if (!GraphTests.isComplete(graph)) {
            throw new IllegalArgumentException("Graph is not complete");
        }
        if (graph.vertexSet().isEmpty()) {
            throw new IllegalArgumentException("Graph contains no vertices");
        }
        if (graph.vertexSet().size() == 1) {
            V start = graph.vertexSet().iterator().next();
            return new GraphWalk<V, E>(graph, start, start, Collections.singletonList(start), Collections.emptyList(), 0.0);
        }
        SimpleGraph<V, DefaultEdge> mst = new SimpleGraph<V, DefaultEdge>(DefaultEdge.class);
        for (V v : graph.vertexSet()) {
            mst.addVertex(v);
        }
        for (Object e : new KruskalMinimumSpanningTree<V, E>(graph).getSpanningTree().getEdges()) {
            mst.addEdge(graph.getEdgeSource(e), graph.getEdgeTarget(e));
        }
        int n = graph.vertexSet().size();
        HashSet found = new HashSet(n);
        ArrayList<V> tour = new ArrayList<V>(n + 1);
        V start = graph.vertexSet().iterator().next();
        DepthFirstIterator dfsIt = new DepthFirstIterator(mst, start);
        while (dfsIt.hasNext()) {
            Object v = dfsIt.next();
            if (!found.add(v)) continue;
            tour.add(v);
        }
        tour.add(start);
        ArrayList<E> tourEdges = new ArrayList<E>(n);
        double tourWeight = 0.0;
        Iterator tourIt = tour.iterator();
        Object u = tourIt.next();
        while (tourIt.hasNext()) {
            Object v = tourIt.next();
            E e = graph.getEdge(u, v);
            tourEdges.add(e);
            tourWeight += graph.getEdgeWeight(e);
            u = v;
        }
        return new GraphWalk<V, E>(graph, start, start, tour, tourEdges, tourWeight);
    }
}

