/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.items.ModItems;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;

public class RiftDecay {
    private static final int MAX_DECAY_CHANCE = 5000;
    private static final Random random = new Random();
    public static Block[] blocksImmuneToDecay = null;

    public static Block[] getBlocksImmuneToDecay() {
        if (blocksImmuneToDecay == null) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add((Object)ModBlocks.UNRAVELLED_FABRIC);
            temp.add((Object)ModBlocks.ETERNAL_FABRIC);
            temp.add(ModBlocks.DIMENSIONAL_PORTAL);
            temp.add(ModBlocks.IRON_DIMENSIONAL_DOOR);
            temp.add(ModBlocks.WARP_DIMENSIONAL_DOOR);
            temp.add(ModBlocks.RIFT);
            temp.add((Object)ModBlocks.GOLD_DOOR);
            temp.add((Object)ModBlocks.QUARTZ_DOOR);
            temp.add(ModBlocks.GOLD_DIMENSIONAL_DOOR);
            for (String blocked : ModConfig.rifts.blockRiftDecayBlackList) {
                Block fromString = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blocked));
                if (fromString != null) {
                    temp.add(fromString);
                    continue;
                }
                DimDoors.log.error("Invalid block name for rift decay blacklist! \"" + blocked + "\"");
            }
            blocksImmuneToDecay = temp.toArray(new Block[0]);
        }
        return blocksImmuneToDecay;
    }

    public static void applySpreadDecay(World world, BlockPos pos, TileEntityFloatingRift rift) {
        float chance = rift.size / 100.0f;
        if (random.nextFloat() * 5000.0f <= chance) {
            BlockPos selected = RiftDecay.getRandomPosInRange(pos, chance / 2.0f);
            RiftDecay.decayBlock(world, selected);
            RiftDecay.decayBlock(world, pos);
        }
    }

    private static BlockPos getRandomPosInRange(BlockPos center, float range) {
        double x = (random.nextDouble() - 0.5) * (double)range;
        double y = (random.nextDouble() - 0.5) * (double)range;
        double z = (random.nextDouble() - 0.5) * (double)range;
        return center.func_177963_a(x > 0.0 ? Math.ceil(x) : Math.floor(x), y > 0.0 ? Math.ceil(y) : Math.floor(y), z > 0.0 ? Math.ceil(z) : Math.floor(z));
    }

    private static boolean decayBlock(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (RiftDecay.canDecayBlock(block, world, pos)) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            if (ModConfig.rifts.enableRiftDecayDropsWorldThread) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.WORLD_THREAD)));
            }
            return true;
        }
        return false;
    }

    private static boolean canDecayBlock(IBlockState state, World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        for (int k = 0; k < RiftDecay.getBlocksImmuneToDecay().length; ++k) {
            if (!state.func_177230_c().equals(RiftDecay.getBlocksImmuneToDecay()[k])) continue;
            return false;
        }
        return !(state instanceof BlockContainer);
    }
}

