/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.client.TileEntityFloatingRiftRenderer;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.IRiftProvider;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.tileentities.TileEntityEntranceRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;

public abstract class ItemDimensionalDoor
extends ItemDoor {
    public <T extends Block> ItemDimensionalDoor(T block) {
        super(block);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result;
        boolean placedOnRift;
        BlockPos originalPos = pos;
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        boolean bl = placedOnRift = world.func_180495_p(pos).func_177230_c() == ModBlocks.RIFT;
        if (!placedOnRift && !player.func_70093_af() && ItemDimensionalDoor.isRiftNear(world, pos)) {
            if (world.field_72995_K) {
                DimDoors.chat((Entity)player, "rifts.entrances.rift_too_close", new Object[0]);
                TileEntityFloatingRiftRenderer.showRiftCoreUntil = System.currentTimeMillis() + (long)ModConfig.graphics.highlightRiftCoreFor;
            }
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            return super.func_180614_a(player, world, originalPos, hand, facing, hitX, hitY, hitZ);
        }
        TileEntityFloatingRift rift = null;
        if (placedOnRift) {
            if (this.canBePlacedOnRift()) {
                rift = (TileEntityFloatingRift)world.func_175625_s(pos);
                rift.setUnregisterDisabled(true);
            } else {
                DimDoors.sendTranslatedMessage((Entity)player, "rifts.entrances.cannot_be_placed_on_rift", new Object[0]);
            }
        }
        if ((result = super.func_180614_a(player, world, originalPos, hand, facing, hitX, hitY, hitZ)) == EnumActionResult.SUCCESS) {
            IBlockState state = world.func_180495_p(pos);
            if (rift == null) {
                TileEntityEntranceRift entranceRift = (TileEntityEntranceRift)((IRiftProvider)state.func_177230_c()).getRift(world, pos, state);
                this.setupRift(entranceRift);
                entranceRift.func_70296_d();
                entranceRift.register();
            } else {
                TileEntityEntranceRift newRift = (TileEntityEntranceRift)world.func_175625_s(pos);
                newRift.copyFrom(rift);
                newRift.updateType();
            }
        } else if (rift != null) {
            rift.setUnregisterDisabled(false);
        }
        return result;
    }

    public static boolean isRiftNear(World world, BlockPos pos) {
        for (int x = pos.func_177958_n() - 5; x < pos.func_177958_n() + 5; ++x) {
            for (int y = pos.func_177956_o() - 5; y < pos.func_177956_o() + 5; ++y) {
                for (int z = pos.func_177952_p() - 5; z < pos.func_177952_p() + 5; ++z) {
                    BlockPos searchPos = new BlockPos(x, y, z);
                    if (world.func_180495_p(searchPos).func_177230_c() != ModBlocks.RIFT) continue;
                    TileEntityFloatingRift rift = (TileEntityFloatingRift)world.func_175625_s(searchPos);
                    if (!(Math.sqrt(pos.func_177951_i((Vec3i)searchPos)) < (double)(rift.size / 150.0f))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".info"))) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".info"), (Object[])new Object[0]));
        }
    }

    public abstract void setupRift(TileEntityEntranceRift var1);

    public abstract boolean canBePlacedOnRift();
}

