/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.items.ModItems;

@SideOnly(value=Side.CLIENT)
public final class ModelManager {
    public static void registerItemModels() {
        ModelManager.registerColored((Item)ModItems.FABRIC);
        ModelManager.registerColored((Item)ModItems.ANCIENT_FABRIC);
        ModelManager.register((Item)ModItems.UNRAVELLED_FABRIC);
        ModelManager.register((Item)ModItems.ETERNAL_FABRIC);
        ModelManager.register((Item)ModItems.WOOD_DIMENSIONAL_TRAPDOOR);
        ModelManager.register((Item)ModItems.IRON_DIMENSIONAL_DOOR);
        ModelManager.register((Item)ModItems.GOLD_DIMENSIONAL_DOOR);
        ModelManager.register((Item)ModItems.GOLD_DOOR);
        ModelManager.register((Item)ModItems.QUARTZ_DIMENSIONAL_DOOR);
        ModelManager.register((Item)ModItems.QUARTZ_DOOR);
        ModelManager.register(ModItems.STABLE_FABRIC);
        ModelManager.register((Item)ModItems.UNSTABLE_DIMENSIONAL_DOOR);
        ModelManager.register((Item)ModItems.WOOD_DIMENSIONAL_DOOR);
        ModelManager.register(ModItems.WORLD_THREAD);
        ModelManager.register(ModItems.RIFT_CONFIGURATION_TOOL);
        ModelManager.register((Item)ModItems.RIFT_BLADE);
        ModelManager.register(ModItems.RIFT_REMOVER);
        ModelManager.register(ModItems.RIFT_SIGNATURE);
        ModelManager.register(ModItems.RIFT_STABILIZER);
        ModelManager.register(ModItems.STABILIZED_RIFT_SIGNATURE);
        ModelManager.register((Item)ModItems.WOVEN_WORLD_THREAD_BOOTS);
        ModelManager.register((Item)ModItems.WOVEN_WORLD_THREAD_CHESTPLATE);
        ModelManager.register((Item)ModItems.WOVEN_WORLD_THREAD_HELMET);
        ModelManager.register((Item)ModItems.WOVEN_WORLD_THREAD_LEGGINGS);
        ModelManager.register((Item)ModItems.CREEPY_RECORD);
        ModelManager.register((Item)ModItems.MARKING_PLATE);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelManager.registerColoredVariants((Item)ModItems.FABRIC);
        ModelManager.registerColoredVariants((Item)ModItems.ANCIENT_FABRIC);
        StateMap ignorePowered = new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.GOLD_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.QUARTZ_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.GOLD_DIMENSIONAL_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.IRON_DIMENSIONAL_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.PERSONAL_DIMENSIONAL_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.WARP_DIMENSIONAL_DOOR, (IStateMapper)ignorePowered);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DIMENSIONAL_PORTAL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176520_a, BlockDoor.field_176523_O, BlockDoor.field_176521_M, BlockDoor.field_176519_b, BlockDoor.field_176522_N}).func_178441_a());
    }

    private static void register(Item item) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void register(Item item, int meta, String name) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(item.getRegistryName() + "_" + name, "inventory"));
    }

    private static void registerColored(Item item) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModelManager.register(item, color.func_176765_a(), color.func_176610_l());
        }
    }

    private static void registerColoredVariants(Item item) {
        ResourceLocation itemName = item.getRegistryName();
        ResourceLocation[] variants = new ResourceLocation[16];
        for (EnumDyeColor color : EnumDyeColor.values()) {
            variants[color.func_176765_a()] = new ResourceLocation(itemName + "_" + color.func_176610_l());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])variants);
    }
}

