/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils;

public final class RGBA {
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;

    public RGBA(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RGBA)) {
            return false;
        }
        RGBA other = (RGBA)o;
        if (Float.compare(this.getRed(), other.getRed()) != 0) {
            return false;
        }
        if (Float.compare(this.getGreen(), other.getGreen()) != 0) {
            return false;
        }
        if (Float.compare(this.getBlue(), other.getBlue()) != 0) {
            return false;
        }
        return Float.compare(this.getAlpha(), other.getAlpha()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getRed());
        result = result * 59 + Float.floatToIntBits(this.getGreen());
        result = result * 59 + Float.floatToIntBits(this.getBlue());
        result = result * 59 + Float.floatToIntBits(this.getAlpha());
        return result;
    }

    public String toString() {
        return "RGBA(red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ", alpha=" + this.getAlpha() + ")";
    }
}

