/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.tileentities;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.blocks.BlockChocoboEgg;
import net.chococraft.common.blocks.BlockStrawNest;
import net.chococraft.common.entities.EntityChocobo;
import net.chococraft.common.entities.breeding.BreedingHelper;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.init.ModBlocks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityChocoboNest
extends TileEntity
implements ITickable {
    private static final CheckOffset[] SHELTER_CHECK_OFFSETS = new CheckOffset[]{new CheckOffset(new Vec3i(0, 1, 0), true), new CheckOffset(new Vec3i(0, 2, 0), true), new CheckOffset(new Vec3i(-1, 3, -1), false), new CheckOffset(new Vec3i(-1, 3, 0), false), new CheckOffset(new Vec3i(-1, 3, 1), false), new CheckOffset(new Vec3i(0, 3, -1), false), new CheckOffset(new Vec3i(0, 3, 0), false), new CheckOffset(new Vec3i(0, 3, 1), false), new CheckOffset(new Vec3i(1, 3, -1), false), new CheckOffset(new Vec3i(1, 3, 0), false), new CheckOffset(new Vec3i(1, 3, 1), false)};
    public static final String NBTKEY_IS_SHELTERED = "IsSheltered";
    public static final String NBTKEY_TICKS = "Ticks";
    public static final String NBTKEY_NEST_INVENTORY = "Inventory";
    private ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileEntityChocoboNest.this.onInventoryChanged();
        }
    };
    private boolean isSheltered;
    private int ticks = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.ticks;
        if (this.ticks > 1000000) {
            this.ticks = 0;
        }
        boolean changed = false;
        if (this.ticks % 5 == 0 && !this.getEggItemStack().func_190926_b()) {
            changed = this.updateEgg();
        }
        if (this.ticks % 200 == 100) {
            changed |= this.updateSheltered();
        }
        if (changed) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    private boolean updateEgg() {
        ItemStack egg = this.getEggItemStack();
        if (!BlockChocoboEgg.isChocoboEgg(egg)) {
            return false;
        }
        if (!egg.func_77942_o()) {
            return false;
        }
        NBTTagCompound nbt = egg.func_190925_c("HatchingState");
        int time = nbt.func_74762_e("Time");
        nbt.func_74768_a("Time", time += this.isSheltered ? 2 : 1);
        if (time < ChocoConfig.breeding.eggHatchTimeTicks) {
            return false;
        }
        ChocoboBreedInfo breedInfo = ChocoboBreedInfo.getFromNbtOrDefault(egg.func_179543_a("BreedInfo"));
        EntityChocobo baby = BreedingHelper.createChild(breedInfo, this.field_145850_b);
        baby.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)baby);
        Random random = baby.func_70681_au();
        for (int i = 0; i < 7; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextDouble() * (double)baby.field_70130_N * 2.0 - (double)baby.field_70130_N;
            double d4 = 0.5 + random.nextDouble() * (double)baby.field_70131_O;
            double d5 = random.nextDouble() * (double)baby.field_70130_N * 2.0 - (double)baby.field_70130_N;
            this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, baby.field_70165_t + d3, baby.field_70163_u + d4, baby.field_70161_v + d5, d0, d1, d2, new int[0]);
        }
        this.setEggItemStack(ItemStack.field_190927_a);
        return true;
    }

    private boolean updateSheltered() {
        boolean sheltered = this.isSheltered();
        if (this.isSheltered != sheltered) {
            this.isSheltered = sheltered;
            return true;
        }
        return false;
    }

    public ItemStack getEggItemStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setEggItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        } else if (BlockChocoboEgg.isChocoboEgg(itemStack)) {
            this.inventory.setStackInSlot(0, itemStack);
            if (itemStack.func_77942_o()) {
                NBTTagCompound nbt = itemStack.func_190925_c("HatchingState");
                int time = nbt.func_74762_e("Time");
                nbt.func_74768_a("Time", time);
            }
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isSheltered = nbt.func_74767_n(NBTKEY_IS_SHELTERED);
        this.ticks = nbt.func_74762_e(NBTKEY_TICKS);
        this.inventory.deserializeNBT(nbt.func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a(NBTKEY_IS_SHELTERED, this.isSheltered);
        nbt.func_74768_a(NBTKEY_TICKS, this.ticks);
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.inventory.deserializeNBT(pkt.func_148857_g().func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("chococraft.container.nest", new Object[0]);
    }

    public void onInventoryChanged() {
        this.func_70296_d();
        IBlockState newState = ModBlocks.strawNest.func_176223_P().func_177226_a((IProperty)BlockStrawNest.HAS_EGG, (Comparable)Boolean.valueOf(!this.getEggItemStack().func_190926_b()));
        this.func_145831_w().func_175656_a(this.func_174877_v(), newState);
    }

    public boolean isSheltered() {
        boolean sheltered = true;
        for (CheckOffset checkOffset : SHELTER_CHECK_OFFSETS) {
            if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177971_a(checkOffset.offset)) == checkOffset.shouldBeAir) continue;
            sheltered = false;
            break;
        }
        return sheltered;
    }

    private static class CheckOffset {
        Vec3i offset;
        boolean shouldBeAir;

        CheckOffset(Vec3i offset, boolean shouldBeAir) {
            this.offset = offset;
            this.shouldBeAir = shouldBeAir;
        }
    }
}

