/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft;

import java.util.HashSet;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.ChococraftGuiHandler;
import net.chococraft.common.CommonProxy;
import net.chococraft.common.commands.CommandChocobo;
import net.chococraft.common.entities.EntityChocobo;
import net.chococraft.common.entities.properties.EntityDataSerializers;
import net.chococraft.common.init.ModItems;
import net.chococraft.common.network.PacketManager;
import net.chococraft.common.world.worldgen.WorldGenGysahlGreen;
import net.chococraft.utils.Log4jFilter;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="chococraft", version="3.1.415.0", acceptedMinecraftVersions="[1.12,1.13)")
public class Chococraft {
    public static final String MODID = "chococraft";
    public static final String VERSION = "3.1.415.0";
    public static final String MC_VERSION = "[1.12,1.13)";
    private static final Chococraft instance = new Chococraft();
    public static final Logger log = LogManager.getLogger((String)"chococraft");
    @SidedProxy(clientSide="net.chococraft.client.ClientProxy", serverSide="net.chococraft.common.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs creativeTab;

    @Mod.InstanceFactory
    public static Chococraft getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public static void onPreInit(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new ChococraftGuiHandler());
        EntityDataSerializers.init();
        PacketManager.init();
        Log4jFilter.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenGysahlGreen(), (int)ChocoConfig.world.gysahlGreenSpawnWeight);
        if (ChocoConfig.world.chocoboSpawnWeight == 0) {
            return;
        }
        HashSet biomes = new HashSet();
        biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
        biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        EntityRegistry.addSpawn(EntityChocobo.class, (int)ChocoConfig.world.chocoboSpawnWeight, (int)ChocoConfig.world.chocoboPackSizeMin, (int)ChocoConfig.world.chocoboPackSizeMax, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes.toArray(new Biome[biomes.size()]));
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandChocobo());
    }

    static {
        creativeTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModItems.gysahlGreen);
            }
        };
    }
}

