/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.nbt.propertymodifier.IPropertyModifier;
import net.machinemuse.numina.common.nbt.propertymodifier.IPropertyModifierDouble;
import net.machinemuse.numina.common.nbt.propertymodifier.PropertyModifierFlatAdditiveDouble;
import net.machinemuse.numina.common.nbt.propertymodifier.PropertyModifierIntLinearAdditive;
import net.machinemuse.numina.common.nbt.propertymodifier.PropertyModifierLinearAdditiveDouble;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PowerModuleBase
implements IPowerModule {
    protected static Map<String, String> units = new HashMap<String, String>();
    protected Map<String, List<IPropertyModifier>> propertyModifiers;
    protected NBTTagCompound defaultTag;
    protected boolean isAllowed;
    EnumModuleTarget moduleTarget;

    public PowerModuleBase(String dataNameIn, EnumModuleTarget moduleTargetIn) {
        this.moduleTarget = moduleTargetIn;
        this.propertyModifiers = new HashMap<String, List<IPropertyModifier>>();
        this.defaultTag = new NBTTagCompound();
        this.defaultTag.func_74757_a("Active", true);
        this.isAllowed = MPSConfig.INSTANCE.getModuleAllowedorDefault(dataNameIn, true);
        this.addBasePropertyDouble("slotPoints", 1.0);
    }

    public PowerModuleBase(EnumModuleTarget moduleTargetIn) {
        this.moduleTarget = moduleTargetIn;
        this.propertyModifiers = new HashMap<String, List<IPropertyModifier>>();
        this.defaultTag = new NBTTagCompound();
        this.defaultTag.func_74757_a("Active", true);
        this.isAllowed = MPSConfig.INSTANCE.getModuleAllowedorDefault(this.getDataName(), true);
        this.addBasePropertyDouble("slotPoints", 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getUnit(String propertyName) {
        String unit = units.get(propertyName);
        if (unit != null && unit.startsWith("powersuits.tradeoff.")) {
            unit = I18n.func_135052_a((String)unit, (Object[])new Object[0]);
        }
        return unit == null ? "" : unit;
    }

    public EnumModuleTarget getTarget() {
        return this.moduleTarget;
    }

    public abstract TextureAtlasSprite getIcon(ItemStack var1);

    public Map<String, List<IPropertyModifier>> getPropertyModifiers() {
        return this.propertyModifiers;
    }

    public NBTTagCompound getNewTag() {
        return this.defaultTag.func_74737_b();
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setIsAllowed(boolean allowed) {
        this.isAllowed = allowed;
    }

    public PowerModuleBase addPropertyModifier(String propertyName, IPropertyModifier modifier) {
        List<IPropertyModifier> modifiers = this.propertyModifiers.get(propertyName);
        if (modifiers == null) {
            modifiers = new LinkedList<IPropertyModifier>();
        }
        modifiers.add(modifier);
        this.propertyModifiers.put(propertyName, modifiers);
        return this;
    }

    public double applyPropertyModifiers(NBTTagCompound itemTag, String propertyName, double propertyValue) {
        Iterable propertyModifiersIterable = this.propertyModifiers.get(propertyName);
        if (propertyModifiersIterable != null && itemTag.func_74764_b(this.getDataName())) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(this.getDataName());
            for (IPropertyModifier modifier : propertyModifiersIterable) {
                if (!(modifier instanceof IPropertyModifierDouble)) continue;
                propertyValue = ((IPropertyModifierDouble)modifier).applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    public PowerModuleBase addTradeoffPropertyDouble(String tradeoffName, String propertyName, double multiplier) {
        String key = this.getDataName() + '.' + propertyName + '.' + tradeoffName + ".multiplier";
        double propFromConfig = MPSConfig.INSTANCE.getPropertyDoubleOrDefault(key, multiplier);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierLinearAdditiveDouble(tradeoffName, propFromConfig));
    }

    public PowerModuleBase addTradeoffPropertyDouble(String tradeoffName, String propertyName, double multiplier, String unit) {
        units.put(propertyName, unit);
        return this.addTradeoffPropertyDouble(tradeoffName, propertyName, multiplier);
    }

    public PowerModuleBase addBasePropertyDouble(String propertyName, double baseVal) {
        String key = this.getDataName() + '.' + propertyName + ".base";
        double propFromConfig = MPSConfig.INSTANCE.getPropertyDoubleOrDefault(key, baseVal);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierFlatAdditiveDouble(propFromConfig));
    }

    public PowerModuleBase addBasePropertyDouble(String propertyName, double baseVal, String unit) {
        units.put(propertyName, unit);
        return this.addBasePropertyDouble(propertyName, baseVal);
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, int multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        String key = this.getDataName() + '.' + propertyName + '.' + tradeoffName + ".multiplier";
        int propFromConfig = MPSConfig.INSTANCE.getPropertyIntegerOrDefault(key, multiplier);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierIntLinearAdditive(tradeoffName, (double)propFromConfig, roundTo, offset));
    }

    public boolean equals(PowerModuleBase other) {
        return other != null && other.getDataName().equals(this.getDataName());
    }

    public String getUnlocalizedName() {
        return "module.powersuits." + this.getDataName();
    }
}

