/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;

public class EntityPlasmaBolt
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public static final int SIZE = 24;
    public double size;
    public double damagingness;
    public double explosiveness;
    public Entity shootingEntity;

    public EntityPlasmaBolt(World world) {
        super(world);
    }

    public EntityPlasmaBolt(World world, EntityLivingBase shootingEntity, double explosivenessIn, double damagingnessIn, int chargeTicks) {
        super(world);
        this.shootingEntity = shootingEntity;
        this.size = chargeTicks > 50 ? 50 : chargeTicks;
        this.explosiveness = explosivenessIn;
        this.damagingness = damagingnessIn;
        Vec3d direction = shootingEntity.func_70040_Z().func_72432_b();
        double scale = 1.0;
        this.field_70159_w = direction.field_72450_a * scale;
        this.field_70181_x = direction.field_72448_b * scale;
        this.field_70179_y = direction.field_72449_c * scale;
        double r = this.size / 50.0;
        double xoffset = (double)1.3f + r - direction.field_72448_b * (double)shootingEntity.func_70047_e();
        double yoffset = -0.2;
        double zoffset = 0.3f;
        double horzScale = Math.sqrt(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c);
        double horzx = direction.field_72450_a / horzScale;
        double horzz = direction.field_72449_c / horzScale;
        this.field_70165_t = shootingEntity.field_70165_t + direction.field_72450_a * xoffset - direction.field_72448_b * horzx * yoffset - horzz * zoffset;
        this.field_70163_u = shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
        this.field_70161_v = shootingEntity.field_70161_v + direction.field_72449_c * xoffset - direction.field_72448_b * horzz * yoffset + horzx * zoffset;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - r, this.field_70163_u - r, this.field_70161_v - r, this.field_70165_t + r, this.field_70163_u + r, this.field_70161_v + r));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > this.getMaxLifetime()) {
            this.func_70106_y();
        }
        if (this.func_70090_H()) {
            this.func_70106_y();
            int var3 = 0;
            while ((double)var3 < this.size) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + Math.random() * 1.0, this.field_70163_u + Math.random() * 1.0, this.field_70161_v + Math.random() * 0.1, 0.0, 0.0, 0.0, new int[0]);
                ++var3;
            }
        }
    }

    public int getMaxLifetime() {
        return 200;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70037_a(NBTTagCompound var1) {
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound var1) {
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70184_a(RayTraceResult result) {
        double damage = this.size / 50.0 * this.damagingness;
        switch (result.field_72313_a) {
            case ENTITY: {
                if (result.field_72308_g == null || result.field_72308_g == this.shootingEntity) break;
                result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), (float)((int)damage));
                break;
            }
            case BLOCK: {
                break;
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.size / 50.0 * 3.0 * this.explosiveness), flag);
        }
        for (int var3 = 0; var3 < 8; ++var3) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + Math.random() * 0.1, this.field_70163_u + Math.random() * 0.1, this.field_70161_v + Math.random() * 0.1, 0.0, 0.0, 0.0, new int[0]);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.size);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.size = additionalData.readDouble();
    }
}

