/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.geometry;

import net.machinemuse.numina.client.gui.geometry.FlyFromPointToPoint2D;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;

public class MuseRect
implements IRect {
    MusePoint2D ul;
    MusePoint2D wh;
    protected IRect belowMe;
    protected IRect aboveMe;
    protected IRect leftOfMe;
    protected IRect rightOfMe;

    public MuseRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.ul = new MusePoint2D(left, top);
        this.wh = new MusePoint2D(right - left, bottom - top);
        if (growFromMiddle) {
            MusePoint2D center = this.ul.plus(this.wh.times(0.5));
            this.ul = new FlyFromPointToPoint2D(center, this.ul, 200.0);
            this.wh = new FlyFromPointToPoint2D(new MusePoint2D(0.0, 0.0), this.wh, 200.0);
        }
    }

    public MuseRect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public MuseRect(MusePoint2D ul, MusePoint2D br) {
        this.ul = ul;
        this.wh = br.minus(ul);
    }

    public MuseRect copyOf() {
        return new MuseRect(this.left(), this.top(), this.right(), this.bottom());
    }

    @Override
    public IRect setUL(MusePoint2D ul) {
        this.ul = ul;
        return this;
    }

    @Override
    public MusePoint2D getUL() {
        return this.ul;
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.wh = wh;
        return this;
    }

    @Override
    public MusePoint2D getWH() {
        return this.wh;
    }

    @Override
    public IRect setHeight(double value) {
        this.wh.setY(value);
        return this;
    }

    @Override
    public double height() {
        return this.wh.y;
    }

    @Override
    public IRect setWidth(double value) {
        this.wh.setX(value);
        return this;
    }

    @Override
    public double width() {
        return this.wh.x;
    }

    @Override
    public IRect setLeft(double value) {
        this.ul.setX(value);
        return this;
    }

    @Override
    public double left() {
        if (this.leftOfMe != null) {
            return this.leftOfMe.right();
        }
        return this.ul.getX();
    }

    @Override
    public IRect setRightOf(IRect leftOfMe) {
        this.leftOfMe = leftOfMe;
        return this;
    }

    @Override
    public IRect setTop(double value) {
        this.ul.setY(value);
        return this;
    }

    @Override
    public double top() {
        if (this.aboveMe != null) {
            return this.aboveMe.bottom();
        }
        return this.ul.getY();
    }

    @Override
    public IRect setBelow(IRect aboveMe) {
        this.aboveMe = aboveMe;
        return this;
    }

    @Override
    public IRect setRight(double value) {
        this.wh.setX(value - this.ul.x);
        return this;
    }

    @Override
    public double right() {
        if (this.rightOfMe != null) {
            return this.rightOfMe.left();
        }
        return this.left() + this.wh.getX();
    }

    @Override
    public IRect setLeftOf(IRect rightOfMe) {
        this.rightOfMe = rightOfMe;
        return this;
    }

    @Override
    public IRect setBottom(double value) {
        this.wh.setY(value - this.ul.y);
        return this;
    }

    @Override
    public double bottom() {
        if (this.belowMe != null) {
            return this.belowMe.top();
        }
        return this.top() + this.wh.getY();
    }

    @Override
    public IRect setAbove(IRect belowMe) {
        this.belowMe = belowMe;
        return this;
    }
}

