/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.geometry;

import net.machinemuse.numina.client.gui.geometry.MusePoint2D;

public interface IRect {
    public double left();

    public IRect setLeft(double var1);

    public double top();

    public IRect setTop(double var1);

    public double right();

    public IRect setRight(double var1);

    public double bottom();

    public IRect setBottom(double var1);

    public double width();

    public IRect setWidth(double var1);

    public double height();

    public IRect setHeight(double var1);

    public MusePoint2D getUL();

    public IRect setUL(MusePoint2D var1);

    public MusePoint2D getWH();

    public IRect setWH(MusePoint2D var1);

    public IRect setAbove(IRect var1);

    public IRect setLeftOf(IRect var1);

    public IRect setBelow(IRect var1);

    public IRect setRightOf(IRect var1);

    default public boolean containsPoint(double x, double y) {
        return x > this.left() && x < this.right() && y > this.top() && y < this.bottom();
    }

    default public MusePoint2D center() {
        return new MusePoint2D(this.centerX(), this.centerY());
    }

    default public double centerX() {
        return (this.left() + this.right()) / 2.0;
    }

    default public double centerY() {
        return (this.top() + this.bottom()) / 2.0;
    }

    default public void moveBy(double x, double y) {
        this.moveBy(new MusePoint2D(x, y));
    }

    default public void moveBy(MusePoint2D amount) {
        this.setUL(this.getUL().plus(amount));
    }

    default public void setPosition(MusePoint2D position) {
        this.setLeft(position.x - this.width() * 0.5);
        this.setTop(position.y - this.height() * 0.5);
    }
}

