/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.network.packet.Utils;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioSign
implements IMessage {
    String[] text;
    int[] textScales;
    int numOfLines;
    int s1Scale;
    int s1Rot;
    int s2Scale;
    int s2Rot;
    int s1x;
    int s1y;
    int s2x;
    int s2y;
    BlockPos pos;

    public BiblioSign() {
    }

    public BiblioSign(String[] text, int[] textScales, int numOfLines, int s1Scale, int s1Rot, int s2Scale, int s2Rot, int s1x, int s1y, int s2x, int s2y, BlockPos pos) {
        this.text = text;
        this.textScales = textScales;
        this.numOfLines = numOfLines;
        this.s1Scale = s1Scale;
        this.s1Rot = s1Rot;
        this.s2Scale = s2Scale;
        this.s2Rot = s2Rot;
        this.s1x = s1x;
        this.s1y = s1y;
        this.s2x = s2x;
        this.s2y = s2y;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.text = new String[15];
        this.textScales = new int[15];
        for (int n = 0; n < 15; ++n) {
            this.text[n] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.textScales[n] = buf.readInt();
        }
        this.numOfLines = buf.readInt();
        this.s1Scale = buf.readInt();
        this.s1Rot = buf.readInt();
        this.s2Scale = buf.readInt();
        this.s2Rot = buf.readInt();
        this.s1x = buf.readInt();
        this.s1y = buf.readInt();
        this.s2x = buf.readInt();
        this.s2y = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        for (int i = 0; i < 15; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text[i]);
            buf.writeInt(this.textScales[i]);
        }
        buf.writeInt(this.numOfLines);
        buf.writeInt(this.s1Scale);
        buf.writeInt(this.s1Rot);
        buf.writeInt(this.s2Scale);
        buf.writeInt(this.s2Rot);
        buf.writeInt(this.s1x);
        buf.writeInt(this.s1y);
        buf.writeInt(this.s2x);
        buf.writeInt(this.s2y);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<BiblioSign, IMessage> {
        public IMessage onMessage(BiblioSign message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                World world;
                TileEntity tile;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (Utils.hasPointLoaded(player, message.pos) && (tile = (world = player.field_70170_p).func_175625_s(message.pos)) != null && tile instanceof TileEntityFancySign) {
                    TileEntityFancySign sign = (TileEntityFancySign)tile;
                    sign.updateFromPacket(message.text, message.textScales, message.numOfLines, message.s1Scale, message.s1Rot, message.s1x, message.s1y, message.s2Scale, message.s2Rot, message.s2x, message.s2y);
                }
            });
            return null;
        }
    }
}

