/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.network.packet.Utils;
import jds.bibliocraft.tileentities.TileEntityClock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioClock
implements IMessage {
    NBTTagCompound tag;
    boolean tick;
    boolean chime;
    boolean rsout;
    boolean rspulse;
    BlockPos pos;

    public BiblioClock() {
    }

    public BiblioClock(NBTTagCompound tag, boolean tick, boolean chime, boolean rsout, boolean rspulse, BlockPos pos) {
        this.tag = tag;
        this.tick = tick;
        this.chime = chime;
        this.rsout = rsout;
        this.rspulse = rspulse;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.tick = buf.readBoolean();
        this.chime = buf.readBoolean();
        this.rsout = buf.readBoolean();
        this.rspulse = buf.readBoolean();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeBoolean(this.tick);
        buf.writeBoolean(this.chime);
        buf.writeBoolean(this.rsout);
        buf.writeBoolean(this.rspulse);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<BiblioClock, IMessage> {
        public IMessage onMessage(BiblioClock message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (Utils.hasPointLoaded(player, message.pos)) {
                    World world = player.field_70170_p;
                    int[] chimes = message.tag.func_74759_k("chimes");
                    int[] redstone = message.tag.func_74759_k("redstone");
                    TileEntity tile = world.func_175625_s(message.pos);
                    if (tile != null && tile instanceof TileEntityClock) {
                        TileEntityClock clock = (TileEntityClock)tile;
                        clock.setSettingFromGui(chimes, redstone, message.tick, message.chime, message.rsout, message.rspulse);
                    }
                }
            });
            return null;
        }
    }
}

