/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import sun.misc.Unsafe;

public class MixinFixer {
    static Unsafe unsafe;
    static Set<String> queuedLateMixinConfigs;

    public static Set<String> retrieveLateMixinConfigs() {
        Set<String> ret = queuedLateMixinConfigs;
        queuedLateMixinConfigs = null;
        return ret;
    }

    static void patchAncientModMixinsLoadingMethod() {
        ClassInfo.registerCallback(ci -> {
            if (!ci.isMixin() && "net/minecraftforge/fml/common/Loader".equals(ci.getName())) {
                try {
                    Field unsafe$theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafe$theUnsafe.setAccessible(true);
                    unsafe = (Unsafe)unsafe$theUnsafe.get(null);
                    Field classInfo$mixinsField = ClassInfo.class.getDeclaredField("mixins");
                    classInfo$mixinsField.setAccessible(true);
                    unsafe.putObject(ci, unsafe.objectFieldOffset(classInfo$mixinsField), new NotifiableMixinSet());
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Unable to patch for compatibility with older mixin mods", e);
                }
            }
        });
    }

    static {
        queuedLateMixinConfigs = new ObjectOpenHashSet();
    }

    private static class EmptyAbsorbingList
    extends AbstractList<String> {
        private EmptyAbsorbingList() {
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return true;
        }

        @Override
        public String get(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static class NotifiableMixinSet
    extends HashSet<IMixinInfo> {
        private static Field mixinInfo$targetClassNames;
        long mixinInfo$targetClassNames$offset = 0L;

        private NotifiableMixinSet() {
        }

        @Override
        public boolean add(IMixinInfo mixinInfo) {
            if (mixinInfo$targetClassNames == null) {
                try {
                    mixinInfo$targetClassNames = mixinInfo.getClass().getDeclaredField("targetClassNames");
                    mixinInfo$targetClassNames.setAccessible(true);
                    this.mixinInfo$targetClassNames$offset = unsafe.objectFieldOffset(mixinInfo$targetClassNames);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Unable to patch for compatibility with older mixin mods", e);
                }
            }
            switch (mixinInfo.getConfig().getName()) {
                case "mixins.integrated_proxy.loader.json": {
                    queuedLateMixinConfigs.add("mixins.integrated_proxy.mod.json");
                    unsafe.putObject(mixinInfo, this.mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.jeid.init.json": {
                    queuedLateMixinConfigs.add("mixins.jeid.modsupport.json");
                    queuedLateMixinConfigs.add("mixins.jeid.twilightforest.json");
                    unsafe.putObject(mixinInfo, this.mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.dj2addons.init.json": {
                    queuedLateMixinConfigs.add("mixins.dj2addons.json");
                    unsafe.putObject(mixinInfo, this.mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.thaumicfixes.init.json": {
                    queuedLateMixinConfigs.add("mixins.thaumicfixes.modsupport.json");
                    unsafe.putObject(mixinInfo, this.mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.loader.json": {
                    if (!"noobanidus.mods.erebusfix.mixins.".equals(mixinInfo.getConfig().getMixinPackage())) break;
                    queuedLateMixinConfigs.add("mixins.erebusfix.json");
                    unsafe.putObject(mixinInfo, this.mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
            }
            return super.add(mixinInfo);
        }
    }
}

