/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba;

import com.latmod.yabba.block.Tier;
import java.util.HashSet;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="yabba")
@Config(modid="yabba", category="")
public class YabbaConfig {
    @Config.LangKey(value="stat.generalButton")
    public static final General general = new General();
    public static final TierCategory tier = new TierCategory();

    public static boolean sync() {
        ConfigManager.sync((String)"yabba", (Config.Type)Config.Type.INSTANCE);
        YabbaConfig.tier.wood.syncWith(Tier.WOOD);
        YabbaConfig.tier.iron.syncWith(Tier.IRON);
        YabbaConfig.tier.gold.syncWith(Tier.GOLD);
        YabbaConfig.tier.diamond.syncWith(Tier.DIAMOND);
        general.blacklistedInputItems = null;
        general.blacklistedCreativeItems = null;
        return true;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("yabba")) {
            YabbaConfig.sync();
        }
    }

    public static class TierCategory {
        public final TierCategoryBase wood = new TierCategoryBase(64);
        public final TierCategoryBase iron = new TierCategoryBase(256);
        public final TierCategoryBase gold = new TierCategoryBase(1024);
        public final TierCategoryBase diamond = new TierCategoryBase(4096);

        private static class TierCategoryBase {
            @Config.RangeInt(min=1, max=1000000)
            @Config.LangKey(value="yabba.config.tier.max_item_stacks")
            public int max_item_stacks;

            public TierCategoryBase(int maxStacks) {
                this.max_item_stacks = maxStacks;
            }

            public void syncWith(Tier tier) {
                tier.maxItemStacks = this.max_item_stacks;
            }
        }
    }

    public static class General {
        @Config.Comment(value={"false to inverse normal behaviour - sneak-click will give you a single item, normal-click will give a stack of items."})
        public boolean sneak_left_click_extracts_stack = true;
        @Config.Comment(value={"How many slots can AntiBarrel have."})
        @Config.RangeInt(min=1, max=32768)
        public int antibarrel_capacity = 1024;
        @Config.Comment(value={"How many items per-type can AntiBarrel have."})
        @Config.RangeInt(min=1)
        public int antibarrel_items_per_type = Integer.MAX_VALUE;
        @Config.Comment(value={"When you fill up a barrel with Star/Infinite Capacity tier (2 billion items), it becomes a creative barrel."})
        public boolean transform_star_to_creative = false;
        @Config.Comment(value={"Item IDs that are blacklisted from insertion in barrels."})
        public String[] barrel_input_blacklist = new String[0];
        @Config.Comment(value={"Item IDs that are blacklisted from using with creative upgrade by players in barrels."})
        public String[] barrel_creative_blacklist = new String[]{"yabba:upgrade_creative", "ftbquests:lootcrate"};
        private HashSet<Item> blacklistedInputItems = null;
        private HashSet<Item> blacklistedCreativeItems = null;

        public boolean isItemBlacklistedInput(Item item) {
            if (this.blacklistedInputItems == null) {
                this.blacklistedInputItems = new HashSet();
                for (String s : this.barrel_input_blacklist) {
                    Item item1 = Item.func_111206_d((String)s);
                    if (item1 == null || item1 == Items.field_190931_a) continue;
                    this.blacklistedInputItems.add(item1);
                }
            }
            return !this.blacklistedInputItems.isEmpty() && this.blacklistedInputItems.contains(item);
        }

        public boolean isItemBlacklistedCreative(Item item) {
            if (this.blacklistedCreativeItems == null) {
                this.blacklistedCreativeItems = new HashSet();
                for (String s : this.barrel_creative_blacklist) {
                    Item item1 = Item.func_111206_d((String)s);
                    if (item1 == null || item1 == Items.field_190931_a) continue;
                    this.blacklistedCreativeItems.add(item1);
                }
            }
            return !this.blacklistedCreativeItems.isEmpty() && this.blacklistedCreativeItems.contains(item);
        }
    }
}

