/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.player;

import com.creativemd.creativecore.common.config.converation.ConfigTypeConveration;
import com.creativemd.creativecore.common.config.gui.GuiPlayerSelectorButton;
import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.mc.PlayerUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PlayerSelector {
    private static HashMap<String, Class<? extends PlayerSelector>> selectorTypes = new HashMap();

    public static void registerSelectorType(String id, Class<? extends PlayerSelector> clazz) {
        selectorTypes.put(id, clazz);
    }

    public static Class<? extends PlayerSelector> get(String id) {
        return selectorTypes.get(id);
    }

    public static String get(Class<? extends PlayerSelector> clazz) {
        for (Map.Entry<String, Class<? extends PlayerSelector>> entry : selectorTypes.entrySet()) {
            if (entry.getValue() != clazz) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Could not find player selector id for " + clazz);
    }

    public static PlayerSelector read(NBTTagCompound nbt) {
        Class<? extends PlayerSelector> clazz = PlayerSelector.get(nbt.func_74779_i("id"));
        if (clazz == null) {
            throw new RuntimeException("Could not find player selector for " + nbt.func_74779_i("id"));
        }
        try {
            PlayerSelector selector = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            selector.readFromNBT(nbt);
            return selector;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("PlayerSelector type " + nbt.func_74779_i("id") + " does not have an empty constructor!");
        }
    }

    public abstract boolean is(EntityPlayer var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    protected abstract void write(NBTTagCompound var1);

    public abstract String info();

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.write(nbt);
        nbt.func_74778_a("id", PlayerSelector.get(this.getClass()));
        return nbt;
    }

    static {
        PlayerSelector.registerSelectorType("and", PlayerSelectorAnd.class);
        PlayerSelector.registerSelectorType("or", PlayerSelectorOr.class);
        PlayerSelector.registerSelectorType("not", PlayerSelectorNot.class);
        PlayerSelector.registerSelectorType("level", PlayerSelectorLevel.class);
        PlayerSelector.registerSelectorType("mode", PlayerSelectorGamemode.class);
        PlayerSelector.registerSelectorType("command", PlayerSelectorCommand.class);
        PlayerSelector.registerSelectorType("selector", PlayerSelectorCommandSelector.class);
        ConfigTypeConveration.registerSpecialType(x -> PlayerSelector.class.isAssignableFrom((Class<?>)x), new ConfigTypeConveration.SimpleConfigTypeConveration<PlayerSelector>(){

            @Override
            public PlayerSelector readElement(PlayerSelector defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return PlayerSelector.read(JsonToNBT.func_180713_a((String)element.getAsString()));
                    }
                    catch (NBTException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(PlayerSelector value, PlayerSelector defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.writeToNBT(new NBTTagCompound()).toString());
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.addControl(new GuiPlayerSelectorButton("data", 0, 0, Math.min(150, parent.width - 50), 14, new PlayerSelectorLevel(0)));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadValue(PlayerSelector value, GuiParent parent) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                button.set(value);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            protected PlayerSelector saveValue(GuiParent parent, Class clazz) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)parent.get("data");
                return button.get();
            }

            @Override
            public PlayerSelector set(ConfigKey.ConfigKeyField key, PlayerSelector value) {
                return value;
            }
        });
    }

    public static class PlayerSelectorCommandSelector
    extends PlayerSelector {
        public String pattern;

        public PlayerSelectorCommandSelector() {
        }

        public PlayerSelectorCommandSelector(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean is(EntityPlayer player) {
            try {
                return EntitySelector.func_193531_b((ICommandSender)player, (String)this.pattern).contains(player);
            }
            catch (CommandException commandException) {
                return false;
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.pattern = nbt.func_74779_i("pattern");
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74778_a("pattern", this.pattern);
        }

        @Override
        public String info() {
            return this.pattern;
        }
    }

    public static class PlayerSelectorCommand
    extends PlayerSelector {
        public String command;

        public PlayerSelectorCommand() {
        }

        public PlayerSelectorCommand(String command) {
            this.command = command;
        }

        @Override
        public boolean is(EntityPlayer player) {
            if (player.func_184102_h() == null) {
                return false;
            }
            ICommand command = (ICommand)player.func_184102_h().func_71187_D().func_71555_a().get(this.command);
            if (command != null) {
                return command.func_184882_a(player.func_184102_h(), (ICommandSender)player);
            }
            return false;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.command = nbt.func_74779_i("command");
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74778_a("command", this.command);
        }

        @Override
        public String info() {
            return "/" + this.command;
        }
    }

    public static class PlayerSelectorLevel
    extends PlayerSelector {
        public int permissionLevel;

        public PlayerSelectorLevel() {
        }

        public PlayerSelectorLevel(int permissionLevel) {
            this.permissionLevel = permissionLevel;
        }

        @Override
        public boolean is(EntityPlayer player) {
            if (player instanceof EntityPlayerMP) {
                UserListOpsEntry entry = (UserListOpsEntry)player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
                if (entry != null) {
                    return entry.func_152644_a() >= this.permissionLevel;
                }
                return player.func_184102_h().func_110455_j() >= this.permissionLevel;
            }
            return true;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.permissionLevel = nbt.func_74762_e("level");
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74768_a("level", this.permissionLevel);
        }

        @Override
        public String info() {
            return "level>=" + this.permissionLevel;
        }
    }

    public static class PlayerSelectorGamemode
    extends PlayerSelector {
        public GameType type;

        public PlayerSelectorGamemode() {
        }

        public PlayerSelectorGamemode(GameType type) {
            this.type = type;
        }

        @Override
        public boolean is(EntityPlayer player) {
            return PlayerUtils.getGameType(player) == this.type;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.type = GameType.func_77146_a((int)nbt.func_74762_e("mode"));
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74768_a("mode", this.type.func_77148_a());
        }

        @Override
        public String info() {
            return this.type.func_77149_b();
        }
    }

    public static class PlayerSelectorNot
    extends PlayerSelector {
        public PlayerSelector selector;

        public PlayerSelectorNot() {
        }

        public PlayerSelectorNot(PlayerSelector selector) {
            this.selector = selector;
        }

        @Override
        public boolean is(EntityPlayer player) {
            return !this.selector.is(player);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.selector = PlayerSelector.read(nbt.func_74775_l("child"));
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74782_a("child", (NBTBase)this.selector.writeToNBT(new NBTTagCompound()));
        }

        @Override
        public String info() {
            return "!" + this.selector.info();
        }
    }

    public static class PlayerSelectorOr
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorOr() {
        }

        public PlayerSelectorOr(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(EntityPlayer player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (!this.selectors[i].is(player)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagList list = nbt.func_150295_c("selectors", 10);
            this.selectors = new PlayerSelector[list.func_74745_c()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.func_150305_b(i));
            }
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.func_74742_a((NBTBase)this.selectors[i].writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("selectors", (NBTBase)list);
        }

        @Override
        public String info() {
            String text = "[";
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text = text + "|";
                }
                text = text + this.selectors[i].info();
            }
            return text + "]";
        }
    }

    public static class PlayerSelectorAnd
    extends PlayerSelector {
        public PlayerSelector[] selectors;

        public PlayerSelectorAnd() {
        }

        public PlayerSelectorAnd(PlayerSelector ... selector) {
            this.selectors = selector;
        }

        @Override
        public boolean is(EntityPlayer player) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].is(player)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagList list = nbt.func_150295_c("selectors", 10);
            this.selectors = new PlayerSelector[list.func_74745_c()];
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i] = PlayerSelector.read(list.func_150305_b(i));
            }
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.selectors.length; ++i) {
                list.func_74742_a((NBTBase)this.selectors[i].writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("selectors", (NBTBase)list);
        }

        @Override
        public String info() {
            String text = "[";
            for (int i = 0; i < this.selectors.length; ++i) {
                if (i > 0) {
                    text = text + "&";
                }
                text = text + this.selectors[i].info();
            }
            return text + "]";
        }
    }
}

