/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import java.lang.reflect.Method;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.command.CommandGCAstroMiner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.player.AsteroidsPlayerHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.RecipeManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBaseSingle;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.BiomeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.ChunkProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;

public class AsteroidsModule
implements IPlanetsModule {
    public static Planet planetAsteroids;
    public static AsteroidsPlayerHandler playerHandler;
    public static Fluid fluidMethaneGas;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidNitrogenGas;
    public static Fluid fluidLiquidMethane;
    public static Fluid fluidLiquidOxygen;
    public static Fluid fluidLiquidNitrogen;
    public static Fluid fluidLiquidArgon;
    public static Fluid fluidAtmosphericGases;

    private Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            ResourceLocation texture = new ResourceLocation("galacticraftplanets:blocks/fluids/" + fluidName);
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName, texture, texture).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        }
        return returnFluid;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        planetAsteroids = new Planet("asteroids").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        playerHandler = new AsteroidsPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)playerHandler);
        AsteroidsEventHandler eventHandler = new AsteroidsEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        RecipeSorter.register((String)"galacticraftplanets:canisterRecipe", CanisterRecipes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        this.registerFluid("methane", 1, 11, 295, true);
        this.registerFluid("atmosphericgases", 1, 13, 295, true);
        this.registerFluid("liquidmethane", 450, 120, 109, false);
        this.registerFluid("liquidoxygen", 1141, 140, 90, false);
        this.registerFluid("liquidnitrogen", 808, 130, 90, false);
        this.registerFluid("nitrogen", 1, 12, 295, true);
        this.registerFluid("carbondioxide", 2, 20, 295, true);
        this.registerFluid("argon", 1, 4, 295, true);
        this.registerFluid("liquidargon", 900, 100, 87, false);
        this.registerFluid("helium", 1, 1, 295, true);
        fluidMethaneGas = FluidRegistry.getFluid((String)"methane");
        fluidAtmosphericGases = FluidRegistry.getFluid((String)"atmosphericgases");
        fluidLiquidMethane = FluidRegistry.getFluid((String)"liquidmethane");
        fluidLiquidOxygen = FluidRegistry.getFluid((String)"liquidoxygen");
        fluidOxygenGas = FluidRegistry.getFluid((String)"oxygen");
        fluidLiquidNitrogen = FluidRegistry.getFluid((String)"liquidnitrogen");
        fluidLiquidArgon = FluidRegistry.getFluid((String)"liquidargon");
        fluidNitrogenGas = FluidRegistry.getFluid((String)"nitrogen");
        AsteroidBlocks.initBlocks();
        AsteroidBlocks.registerBlocks();
        AsteroidBlocks.setHarvestLevels();
        AsteroidsItems.initItems();
        planetAsteroids.setBiomeInfo(BiomeAsteroids.asteroid);
        ((BiomeAsteroids)BiomeAsteroids.asteroid).resetMonsterListByMode(ConfigManagerCore.challengeMobDropsAndSpawning);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        AsteroidBlocks.oreDictRegistration();
        AsteroidsItems.oreDictRegistrations();
        GalacticraftCore.galacticraftItemsTab.setItemForTab(new ItemStack(AsteroidsItems.astroMiner));
        this.registerMicroBlocks();
        SchematicRegistry.registerSchematicRecipe(new SchematicTier3Rocket());
        SchematicRegistry.registerSchematicRecipe(new SchematicAstroMiner());
        GalacticraftCore.packetPipeline.addDiscriminator(7, PacketSimpleAsteroids.class);
        AsteroidsTickHandlerServer eventHandler = new AsteroidsTickHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.registerEntities();
        RecipeManagerAsteroids.loadCompatibilityRecipes();
        planetAsteroids.setDimensionInfo(ConfigManagerAsteroids.dimensionIDAsteroids, WorldProviderAsteroids.class).setTierRequired(3);
        planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.375f, 1.375f)).setRelativeOrbitTime(45.0f).setPhaseShift((float)(Math.random() * (Math.PI * 2)));
        planetAsteroids.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/asteroid.png"));
        planetAsteroids.setAtmosphere(new AtmosphereInfo(false, false, false, -1.5f, 0.05f, 0.0f));
        planetAsteroids.addChecklistKeys("equip_oxygen_suit", "craft_grapple_hook", "thermal_padding");
        GalaxyRegistry.register(planetAsteroids);
        GalacticraftRegistry.registerTeleportType(WorldProviderAsteroids.class, new TeleportTypeAsteroids());
        GalacticraftRegistry.registerGear(6, EnumExtendedInventorySlot.THERMAL_HELMET, new ItemStack(AsteroidsItems.thermalPadding, 1, 0));
        GalacticraftRegistry.registerGear(7, EnumExtendedInventorySlot.THERMAL_CHESTPLATE, new ItemStack(AsteroidsItems.thermalPadding, 1, 1));
        GalacticraftRegistry.registerGear(8, EnumExtendedInventorySlot.THERMAL_LEGGINGS, new ItemStack(AsteroidsItems.thermalPadding, 1, 2));
        GalacticraftRegistry.registerGear(9, EnumExtendedInventorySlot.THERMAL_BOOTS, new ItemStack(AsteroidsItems.thermalPadding, 1, 3));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        GCPlanetDimensions.ASTEROIDS = WorldUtil.getDimensionTypeById(ConfigManagerAsteroids.dimensionIDAsteroids);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGCAstroMiner());
        ChunkProviderAsteroids.reset();
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
        AsteroidsTickHandlerServer.restart();
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.SERVER) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            switch (ID) {
                case 3: {
                    if (tile instanceof TileEntityShortRangeTelepad) {
                        return new ContainerShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile, player);
                    }
                    if (!(tile instanceof TileEntityMinerBase)) break;
                    return new ContainerAstroMinerDock(player.field_71071_by, (IInventory)((TileEntityMinerBase)tile));
                }
            }
        }
        return null;
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    private void registerCreatures() {
    }

    private void registerNonMobEntities() {
        MarsModule.registerGalacticraftNonMobEntity(EntitySmallAsteroid.class, "small_asteroid", 150, 3, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityGrapple.class, "grapple_hook", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityTier3Rocket.class, "rocket_t3", 150, 1, false);
        MarsModule.registerGalacticraftNonMobEntity(EntityEntryPod.class, "entry_pod", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityAstroMiner.class, "astro_miner", 80, 1, true);
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 0), "tile.asteroids_block.asteroid_rock_0");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 1), "tile.asteroids_block.asteroid_rock_1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 2), "tile.asteroids_block.asteroid_rock_2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockDenseIce, 0), "tile.dense_ice");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTileEntities() {
        this.register(TileEntityBeamReflector.class, "gc_beam_reflector");
        this.register(TileEntityBeamReceiver.class, "gc_beam_receiver");
        this.register(TileEntityShortRangeTelepad.class, "gc_short_range_telepad");
        this.register(TileEntityTelepadFake.class, "gc_fake_short_range_telepad");
        this.register(TileEntityMinerBaseSingle.class, "gc_astro_miner_base_builder");
        this.register(TileEntityMinerBase.class, "gc_astro_miner_base");
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerAsteroids.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerAsteroids.syncConfig(false, false);
    }
}

