/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.preview;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.api.block.SpecialBlockHandler;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.combine.ICombinable;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.IngredientUtils;
import com.creativemd.littletiles.common.util.outdated.LittleSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittlePreview
implements ICombinable {
    private static HashMap<String, Class<? extends LittlePreview>> previewTypes = new HashMap();
    protected NBTTagCompound tileData;
    public LittleBox box;
    public static int lowResolutionMode = 2000;

    public static void registerPreviewType(String id, Class<? extends LittlePreview> type) {
        previewTypes.put(id, type);
    }

    public String getTypeId() {
        return LittleTileRegistry.getPreviewId(this.getClass());
    }

    public String getTypeIdToSave() {
        if (this.isCustomPreview()) {
            return LittleTileRegistry.getPreviewId(this.getClass());
        }
        return null;
    }

    public boolean isCustomPreview() {
        return this.getClass() != LittleTileRegistry.getDefaultPreviewClass();
    }

    public LittlePreview(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bBoxminX") || nbt.func_74764_b("bBox")) {
            this.box = LittleBox.loadBox("bBox", nbt);
        } else if (nbt.func_74764_b("sizex") || nbt.func_74764_b("size")) {
            LittleVec size = LittleSize.loadSize("size", nbt);
            this.box = new LittleBox(0, 0, 0, size.x, size.y, size.z);
        } else {
            this.box = new LittleBox(0, 0, 0, 1, 1, 1);
        }
        if (nbt.func_74764_b("tile")) {
            this.tileData = nbt.func_74775_l("tile");
        } else {
            this.tileData = nbt.func_74737_b();
            this.tileData.func_82580_o("bBox");
            this.tileData.func_82580_o("size");
        }
        this.tileData.func_82580_o("nodrop");
        if (this.tileData.func_74764_b("tID") && !LittleTileRegistry.getTileType((String)this.tileData.func_74779_i((String)"tID")).saveId) {
            this.tileData.func_82580_o("tID");
        }
        if (this.tileData.func_74764_b("meta")) {
            int meta = this.tileData.func_74762_e("meta");
            this.tileData.func_82580_o("meta");
            if (meta != 0) {
                this.tileData.func_74778_a("block", this.tileData.func_74779_i("block") + ":" + meta);
            }
        }
    }

    public LittlePreview(LittleBox box, NBTTagCompound tileData) {
        this.box = box;
        this.tileData = tileData;
    }

    public String getBlockInfo() {
        return this.tileData.func_74779_i("block");
    }

    public String getBlockName() {
        String[] parts = this.tileData.func_74779_i("block").split(":");
        if (parts.length < 2) {
            return parts[0];
        }
        return parts[0] + ":" + parts[1];
    }

    public Block getBlock() {
        return Block.func_149684_b((String)this.getBlockName());
    }

    public int getMeta() {
        String[] parts = this.tileData.func_74779_i("block").split(":");
        if (parts.length == 3) {
            return Integer.parseInt(parts[2]);
        }
        return 0;
    }

    public boolean hasColor() {
        return this.tileData.func_74764_b("color");
    }

    public int getColor() {
        if (this.tileData.func_74764_b("color")) {
            return this.tileData.func_74762_e("color");
        }
        return -1;
    }

    public void setColor(int color) {
        if (ColorUtils.isWhite((int)color) && !ColorUtils.isTransparent((int)color)) {
            if (this.tileData.func_74779_i("tID").equals("BlockTileColored")) {
                this.tileData.func_74778_a("tID", "BlockTileBlock");
            }
            this.tileData.func_82580_o("color");
        } else {
            if (this.tileData.func_74779_i("tID").equals("BlockTileBlock")) {
                this.tileData.func_74778_a("tID", "BlockTileColored");
            }
            this.tileData.func_74768_a("color", color);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public RenderBox getCubeBlock(LittleGridContext context) {
        LittleRenderBox cube = this.box.getRenderingCube(context, this.getBlock(), this.getMeta());
        cube.color = this.getColor();
        return cube;
    }

    public boolean isInvisible() {
        return this.tileData.func_74767_n("invisible") || ColorUtils.isInvisible((int)this.getColor());
    }

    public void setInvisibile(boolean invisible) {
        this.tileData.func_74757_a("invisible", invisible);
    }

    public NBTTagCompound getTileData() {
        return this.tileData;
    }

    @Nullable
    public BlockIngredientEntry getBlockIngredient(LittleGridContext context) {
        return IngredientUtils.getBlockIngredient(this.getBlock(), this.getMeta(), this.getPercentVolume(context));
    }

    public ItemStack getBlockStack() {
        return new ItemStack(this.getBlock(), 1, this.getMeta());
    }

    public double getPercentVolume(LittleGridContext context) {
        return this.box.getPercentVolume(context);
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        this.box.convertTo(from, to);
    }

    public void convertTo(int from, int to) {
        this.box.convertTo(from, to);
    }

    public boolean canBeCombined(LittlePreview preview) {
        return this.tileData.equals((Object)preview.getTileData());
    }

    @Override
    public LittleBox getBox() {
        return this.box;
    }

    @Override
    public void setBox(LittleBox box) {
        this.box = box;
    }

    @Override
    public boolean canCombine(ICombinable combinable) {
        return this.canBeCombined((LittlePreview)combinable);
    }

    @Override
    public boolean fillInSpace(LittleBox otherBox, boolean[][][] filled) {
        return this.box.fillInSpace(otherBox, filled);
    }

    @Override
    public LittlePreview copy() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        nbt.func_74782_a("tile", (NBTBase)this.tileData.func_74737_b());
        return LittleTileRegistry.loadPreview(nbt);
    }

    public ISpecialBlockHandler getSpecialHandler() {
        return SpecialBlockHandler.getSpecialBlockHandler(this.getBlock(), this.getMeta());
    }

    public String toString() {
        return this.box.toString();
    }

    public LittleTile getLittleTile() {
        return LittleTileRegistry.loadTile(this.tileData);
    }

    public PlacePreview getPlaceableTile(LittleVec offset) {
        LittleBox newBox = this.box.copy();
        if (offset != null) {
            newBox.add(offset);
        }
        return new PlacePreview(newBox, this);
    }

    public void flipPreview(EnumFacing.Axis axis, LittleVec doubledCenter) {
        this.box.flipBox(axis, doubledCenter);
        this.getSpecialHandler().flipPreview(axis, this, doubledCenter);
    }

    public void rotatePreview(Rotation rotation, LittleVec doubledCenter) {
        this.box.rotateBox(rotation, doubledCenter);
        this.getSpecialHandler().rotatePreview(rotation, this, doubledCenter);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("bBox", (NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("tile", (NBTBase)this.tileData);
        if (this.isCustomPreview()) {
            nbt.func_74778_a("type", this.getTypeId());
        }
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            copy.func_82580_o("boxes");
            copy.func_74783_a("bBox", list.func_150306_c(i));
            tags.add(copy);
        }
        return tags;
    }

    public boolean canBeNBTGrouped(LittlePreview preview) {
        return this.box != null && preview.box != null && preview.getTileData().equals((Object)this.getTileData());
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        nbt.func_82580_o("bBox");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public void groupNBTTile(NBTTagCompound nbt, LittlePreview preview) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)preview.box.getNBTIntArray());
    }

    public static LittlePreviews getPreview(ItemStack stack) {
        return LittlePreview.getPreview(stack, false);
    }

    public static LittlePreviews getPreview(ItemStack stack, boolean allowLowResolution) {
        return LittlePreviews.getPreview(stack, allowLowResolution);
    }

    public static LittleVec getSize(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            return LittleSize.loadSize("size", stack.func_77978_p());
        }
        return new LittleVec(1, 1, 1);
    }

    public static LittleVec getOffset(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("min")) {
            return new LittleVec("min", stack.func_77978_p());
        }
        return null;
    }

    public static void removePreviewTiles(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        LittleGridContext.remove(nbt);
        nbt.func_82580_o("size");
        nbt.func_82580_o("min");
        nbt.func_82580_o("pos");
        nbt.func_82580_o("tiles");
        nbt.func_82580_o("count");
        nbt.func_82580_o("children");
    }

    public static NBTTagCompound saveChildPreviews(LittlePreviews previews) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (previews.hasStructure()) {
            nbt.func_74782_a("structure", (NBTBase)previews.structureNBT);
            if (previews.isDynamic()) {
                nbt.func_74757_a("dynamic", true);
            }
        }
        NBTTagList list = LittleNBTCompressionTools.writePreviews(previews);
        nbt.func_74782_a("tiles", (NBTBase)list);
        nbt.func_74768_a("count", previews.size());
        if (previews.hasChildren()) {
            NBTTagList children = new NBTTagList();
            for (LittlePreviews child : previews.getChildren()) {
                children.func_74742_a((NBTBase)LittlePreview.saveChildPreviews(child));
            }
            nbt.func_74782_a("children", (NBTBase)children);
        }
        return nbt;
    }

    public static void savePreview(LittlePreviews previews, ItemStack stack) {
        NBTTagList list;
        if (previews instanceof LittleAbsolutePreviews) {
            throw new IllegalArgumentException("Absolute positions cannot be saved!");
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (previews.hasStructure()) {
            stack.func_77978_p().func_74782_a("structure", (NBTBase)previews.structureNBT);
        }
        previews.getContext().set(stack.func_77978_p());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittlePreview preview : previews.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).writeToNBT("size", stack.func_77978_p());
        new LittleVec(minX, minY, minZ).writeToNBT("min", stack.func_77978_p());
        if (previews.totalSize() >= lowResolutionMode) {
            list = new NBTTagList();
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int i = 0; i < previews.size(); ++i) {
                BlockPos pos = previews.get((int)i).box.getMinVec().getBlockPos(previews.getContext());
                if (positions.contains(pos)) continue;
                positions.add(pos);
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
            stack.func_77978_p().func_74782_a("pos", (NBTBase)list);
        } else {
            stack.func_77978_p().func_82580_o("pos");
        }
        list = LittleNBTCompressionTools.writePreviews(previews);
        stack.func_77978_p().func_74782_a("tiles", (NBTBase)list);
        stack.func_77978_p().func_74768_a("count", previews.size());
        if (previews.hasChildren()) {
            NBTTagList children = new NBTTagList();
            for (LittlePreviews child : previews.getChildren()) {
                children.func_74742_a((NBTBase)LittlePreview.saveChildPreviews(child));
            }
            stack.func_77978_p().func_74782_a("children", (NBTBase)children);
        } else {
            stack.func_77978_p().func_82580_o("children");
        }
    }

    public static void saveTiles(World world, LittleGridContext context, TileEntityLittleTiles te, ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        LittlePreviews previews = new LittlePreviews(context);
        for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
            previews.addTile((IParentTileList)pair.key, (LittleTile)pair.value);
        }
        LittlePreview.savePreview(previews, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<RenderBox> getCubes(LittlePreviews previews) {
        ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
        for (LittlePreview preview : previews.allPreviews()) {
            if (preview.isInvisible()) continue;
            cubes.add(preview.getCubeBlock(previews.getContext()));
        }
        return cubes;
    }

    public static void shrinkCubesToOneBlock(List<RenderBox> cubes) {
        float sizeZ;
        float sizeY;
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (RenderBox box : cubes) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        float scale = 1.0f;
        float sizeX = maxX - minX;
        if (sizeX > 1.0f) {
            scale = Math.min(scale, 1.0f / sizeX);
        }
        if ((sizeY = maxY - minY) > 1.0f) {
            scale = Math.min(scale, 1.0f / sizeY);
        }
        if ((sizeZ = maxZ - minZ) > 1.0f) {
            scale = Math.min(scale, 1.0f / sizeZ);
        }
        float offsetX = -minX;
        float offsetY = -minY;
        float offsetZ = -minZ;
        float offsetX2 = (1.0f - sizeX * scale) * 0.5f;
        float offsetY2 = (1.0f - sizeY * scale) * 0.5f;
        float offsetZ2 = (1.0f - sizeZ * scale) * 0.5f;
        for (RenderBox box : cubes) {
            box.add(offsetX, offsetY, offsetZ);
            box.scale(scale);
            box.add(offsetX2, offsetY2, offsetZ2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<RenderBox> getCubesForStackRendering(ItemStack stack) {
        ArrayList<RenderBox> cubes = LittlePreview.getCubes(stack, true);
        LittlePreview.shrinkCubesToOneBlock(cubes);
        return cubes;
    }

    public static int getTotalCount(NBTTagCompound nbt) {
        int count = nbt.func_74762_e("count");
        if (nbt.func_74764_b("children")) {
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                count += LittlePreview.getTotalCount(list.func_150305_b(i));
            }
        }
        return count;
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderBox> getCubes(ItemStack stack, boolean allowLowResolution) {
        ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
        if (stack.func_77942_o() && LittlePreview.getTotalCount(stack.func_77978_p()) >= lowResolutionMode && allowLowResolution) {
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                cubes.add(new RenderBox((float)array[0], (float)array[1], (float)array[2], (float)(array[0] + 1), (float)(array[1] + 1), (float)(array[2] + 1), (Block)LittleTiles.dyeableBlock));
            }
        } else {
            LittlePreviews previews = LittlePreview.getPreview(stack);
            for (LittlePreview preview : previews.allPreviews()) {
                if (preview.isInvisible()) continue;
                cubes.add(preview.getCubeBlock(previews.getContext()));
            }
        }
        return cubes;
    }
}

