/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.tile;

import com.creativemd.creativecore.client.rendering.face.IFaceRenderType;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;

public class LittleRenderBoxTransformable
extends LittleRenderBox {
    private float scale;
    private float inverseScale;
    public LittleTransformableBox.VectorFanCache cache;

    public LittleRenderBoxTransformable(AlignedBox cube, LittleGridContext context, LittleTransformableBox box, Block block, int meta) {
        super(cube, box, block, meta);
        this.cache = box.requestCache();
        this.scale = (float)context.pixelSize;
        this.inverseScale = context.size;
    }

    public void add(float x, float y, float z) {
        super.add(x, y, z);
        this.cache.add(x * this.inverseScale, y * this.inverseScale, z * this.inverseScale);
    }

    public void sub(float x, float y, float z) {
        super.sub(x, y, z);
        this.cache.sub(x * this.inverseScale, y * this.inverseScale, z * this.inverseScale);
    }

    public void scale(float scale) {
        super.scale(scale);
        this.cache.scale(scale);
    }

    public LittleTransformableBox.VectorFanFaceCache getFaceCache(EnumFacing facing) {
        if (this.cache != null) {
            return this.cache.get(facing);
        }
        return null;
    }

    public boolean renderSide(EnumFacing facing) {
        LittleTransformableBox.VectorFanFaceCache cache = this.getFaceCache(facing);
        if (cache == null) {
            return false;
        }
        if (cache.hasAxisStrip() && super.renderSide(facing)) {
            return true;
        }
        return cache.hasTiltedStripsRendering();
    }

    protected Object getRenderQuads(EnumFacing facing) {
        if (this.getType(facing).hasCachedFans()) {
            return this.getType(facing).getCachedFans();
        }
        LittleTransformableBox.VectorFanFaceCache cache = this.getFaceCache(facing);
        if (cache.hasTiltedStripsRendering()) {
            if (super.renderSide(facing) && cache.hasAxisStrip()) {
                ArrayList<VectorFan> strips = new ArrayList<VectorFan>(cache.axisStrips);
                cache.collectAllTiltedStripsRendering(strips);
                return strips;
            }
            if (cache.hasSingleTiltedStripRendering()) {
                return cache.getSingleTiltedStripRendering();
            }
            ArrayList<VectorFan> strips = new ArrayList<VectorFan>();
            cache.collectAllTiltedStripsRendering(strips);
            return strips;
        }
        if (super.renderSide(facing)) {
            return cache.axisStrips;
        }
        return null;
    }

    public float getPreviewOffX() {
        return 0.0f;
    }

    public float getPreviewOffY() {
        return 0.0f;
    }

    public float getPreviewOffZ() {
        return 0.0f;
    }

    public float getPreviewScaleX() {
        return this.scale;
    }

    public float getPreviewScaleY() {
        return this.scale;
    }

    public float getPreviewScaleZ() {
        return this.scale;
    }

    protected boolean scaleAndOffsetQuads(EnumFacing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(EnumFacing facing) {
        return true;
    }

    protected float getOverallScale(EnumFacing facing) {
        IFaceRenderType type = this.getType(facing);
        if (type.hasCachedFans()) {
            return type.getScale();
        }
        return this.scale;
    }
}

