/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.api.ILittleIngredientSupplier;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class LittleSubGuiUtils {
    public static GuiStackSelectorAll.StackCollector getCollector(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new LittleBlockSelector());
        }
        return new LittleBlockCollector((GuiStackSelectorAll.StackSelector)new LittleBlockSelector());
    }

    public static class LittleBlockCollector
    extends GuiStackSelectorAll.InventoryCollector {
        public LittleBlockCollector(GuiStackSelectorAll.StackSelector selector) {
            super(selector);
        }

        protected void collect(IItemHandler inventory, BlockIngredient ingredients) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() instanceof ILittleIngredientInventory) {
                    LittleIngredients ingredientsInventory = ((ILittleIngredientInventory)stack.func_77973_b()).getInventory(stack);
                    if (ingredientsInventory == null || !ingredientsInventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(ingredientsInventory.get(BlockIngredient.class));
                    continue;
                }
                if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
                this.collect((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ingredients);
            }
        }

        public HashMapList<String, ItemStack> collect(EntityPlayer player) {
            HashMapList stacks = super.collect(player);
            BlockIngredient ingredients = new BlockIngredient();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() instanceof ILittleIngredientSupplier) {
                    ((ILittleIngredientSupplier)stack.func_77973_b()).collect((HashMapList<String, ItemStack>)stacks, stack, player);
                    continue;
                }
                if (stack.func_77973_b() instanceof ILittleIngredientInventory) {
                    LittleIngredients inventory = ((ILittleIngredientInventory)stack.func_77973_b()).getInventory(stack);
                    if (inventory == null || !inventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(inventory.get(BlockIngredient.class));
                    continue;
                }
                if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
                this.collect((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ingredients);
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (BlockIngredientEntry ingredient : ingredients) {
                ItemStack stack = ingredient.getItemStack();
                stack.func_190920_e(Math.max(1, (int)ingredient.value));
                NBTTagCompound display = new NBTTagCompound();
                NBTTagList list = new NBTTagList();
                int blocks = (int)ingredient.value;
                double pixel = (ingredient.value - (double)blocks) * (double)LittleGridContext.get().maxTilesPerBlock;
                list.func_74742_a((NBTBase)new NBTTagString((blocks > 0 ? blocks + " blocks " : "") + (pixel > 0.0 ? Math.round(pixel * 100.0) / 100L + " pixel" : "")));
                display.func_74782_a("Lore", (NBTBase)list);
                stack.func_77983_a("display", (NBTBase)display);
                newStacks.add(stack);
            }
            stacks.add((Object)"selector.ingredients", newStacks);
            return stacks;
        }
    }

    public static class LittleBlockSelector
    extends GuiStackSelectorAll.GuiBlockSelector {
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return LittleAction.isBlockValid(BlockUtils.getState((ItemStack)stack));
            }
            return false;
        }
    }
}

