/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerAccessData {
    static final String PLAYERACCESSLIST = "playeraccesslist";
    private static final String PLAYER = "player";
    private static final String ACCESS = "access";
    private static final String IRIS = "iris";
    private static final String ADMIN = "admin";
    private String playerName;
    private boolean access;
    private boolean iris;
    private boolean admin;

    public PlayerAccessData(String playerName, boolean access, boolean iris, boolean admin) {
        this.playerName = playerName;
        this.access = access;
        this.iris = iris;
        this.admin = admin;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public boolean hasGateAccess() {
        return this.access;
    }

    public void setGateAccess(boolean value) {
        this.access = value;
    }

    public boolean hasIrisAccess() {
        return this.iris;
    }

    public void setIrisAccess(boolean value) {
        this.iris = value;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean value) {
        this.admin = value;
    }

    public static void updatePlayer(EntityPlayer player, NBTTagCompound compound, String oldPlayerName, String newPlayerName, boolean newAccess, boolean newIris, boolean newAdmin, int command) {
        Preconditions.checkNotNull((Object)compound);
        ArrayList<PlayerAccessData> playerAccessData = new ArrayList<PlayerAccessData>();
        NBTTagList list = compound.func_150295_c(PLAYERACCESSLIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound accessCompound = list.func_150305_b(i);
            String compoundEntryPlayerName = accessCompound.func_74779_i(PLAYER);
            if (!compoundEntryPlayerName.equalsIgnoreCase(oldPlayerName)) continue;
            accessCompound.func_74778_a(PLAYER, newPlayerName);
            accessCompound.func_74757_a(ACCESS, newAccess);
            accessCompound.func_74757_a(IRIS, newIris);
            accessCompound.func_74757_a(ADMIN, newIris);
        }
        if (command == 1) {
            playerAccessData.add(new PlayerAccessData(newPlayerName, newAccess, newIris, newAdmin));
        }
        PlayerAccessData.writeAddresses(compound, playerAccessData);
    }

    public static List<PlayerAccessData> getPlayerAccessList(NBTTagCompound compound) {
        Preconditions.checkNotNull((Object)compound);
        if (!compound.func_74764_b(PLAYERACCESSLIST)) {
            ArrayList genericAddressList = Lists.newArrayList();
            PlayerAccessData.writeAddresses(compound, genericAddressList);
        }
        ArrayList<PlayerAccessData> playerAccessData = new ArrayList<PlayerAccessData>();
        NBTTagList list = compound.func_150295_c(PLAYERACCESSLIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound addressCompound = list.func_150305_b(i);
            String name = addressCompound.func_74779_i(PLAYER);
            boolean access = addressCompound.func_74767_n(ACCESS);
            boolean iris = addressCompound.func_74767_n(IRIS);
            boolean admin = addressCompound.func_74767_n(ADMIN);
            playerAccessData.add(new PlayerAccessData(name, access, iris, admin));
        }
        return playerAccessData;
    }

    public static NBTTagCompound writeAddresses(NBTTagCompound compound, List<PlayerAccessData> playerAccessData) {
        Preconditions.checkNotNull((Object)compound);
        Preconditions.checkNotNull(playerAccessData);
        if (playerAccessData.size() >= 0) {
            NBTTagList list = new NBTTagList();
            for (PlayerAccessData data : playerAccessData) {
                NBTTagCompound addressCompound = new NBTTagCompound();
                addressCompound.func_74778_a(PLAYER, data.getPlayerName());
                addressCompound.func_74757_a(ACCESS, data.hasGateAccess());
                addressCompound.func_74757_a(IRIS, data.hasIrisAccess());
                addressCompound.func_74757_a(ADMIN, data.isAdmin());
                list.func_74742_a((NBTBase)addressCompound);
            }
            compound.func_74782_a(PLAYERACCESSLIST, (NBTBase)list);
        }
        return compound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerAccessData that = (PlayerAccessData)o;
        return Objects.equals(this.playerName, that.playerName);
    }

    public int hashCode() {
        return Objects.hash(this.playerName);
    }
}

